/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Random;
import util.GUIUtils;

public class PdfSigner {
    public String sign(InputStream is, OutputStream os, PrivateKey pk, Certificate[] chain, String ownerPassword, boolean isMultipleAllowed, boolean isVisible, Rectangle signRectangle, int[] signatureOnPage, String reason, String location, String selectedImage, List rList, String type) {
        PdfReader reader = null;
        PdfStamper stp = null;
        try {
            reader = ownerPassword == null || ownerPassword != null && ownerPassword.trim().length() == 0 ? new PdfReader(is) : new PdfReader(is, ownerPassword.trim().getBytes());
        }
        catch (IOException e2) {
            return "e1001";
        }
        try {
            stp = PdfStamper.createSignature(reader, os, '\u0000', null, true);
        }
        catch (IOException ex) {
            return "e1002";
        }
        catch (DocumentException ex) {
            return "e1003";
        }
        if (type.equals("EVAL")) {
            int m2 = 1;
            int n2 = reader.getNumberOfPages();
            Image img = null;
            try {
                URL imageURL = GUIUtils.class.getClassLoader().getResource("images/blank.jpg");
                img = Image.getInstance(imageURL);
            }
            catch (BadElementException imageURL) {
            }
            catch (MalformedURLException imageURL) {
            }
            catch (IOException imageURL) {
                // empty catch block
            }
            BaseFont bf = null;
            try {
                bf = BaseFont.createFont("Helvetica", "Cp1252", true);
            }
            catch (DocumentException documentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            img.setAbsolutePosition(200.0f, 400.0f);
            img.setRotationDegrees(45.0f);
            img.setTransparency(new int[]{255, 255, 255, 255, 255, 255});
            while (m2 < n2) {
                PdfContentByte under = stp.getUnderContent(m2);
                try {
                    under.addImage(img);
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
                PdfContentByte over = stp.getOverContent(m2);
                over.beginText();
                over.setFontAndSize(bf, 18.0f);
                over.endText();
                ++m2;
            }
        }
        PdfSignatureAppearance sap = stp.getSignatureAppearance();
        sap.setCrypto(pk, chain, null, PdfSignatureAppearance.WINCER_SIGNED);
        if (!reason.equals("")) {
            sap.setReason(reason);
        }
        if (!location.equals("")) {
            sap.setLocation(location);
        }
        Random random = new Random();
        byte[] signnamebytes = new byte[20];
        random.nextBytes(signnamebytes);
        if (isVisible) {
            try {
                sap.setVisibleSignature(signRectangle, signatureOnPage, null, rList);
            }
            catch (IllegalArgumentException ex) {
                return "e1007";
            }
        }
        if (selectedImage != null && !selectedImage.equals("") && rList.size() == 0) {
            int i2 = 0;
            while (i2 < signatureOnPage.length) {
                Image image = null;
                try {
                    image = Image.getInstance(selectedImage);
                    image.setAbsolutePosition(signRectangle.getLeft(), signRectangle.getBottom() + 65.0f);
                    image.scaleAbsoluteWidth(125.0f);
                    image.scaleAbsoluteHeight(65.0f);
                }
                catch (BadElementException bf) {
                }
                catch (MalformedURLException bf) {
                }
                catch (IOException bf) {
                    // empty catch block
                }
                PdfContentByte pb = stp.getOverContent(signatureOnPage[i2]);
                try {
                    pb.addImage(image);
                    pb = null;
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
                ++i2;
            }
        }
        if (isMultipleAllowed) {
            sap.setCertificationLevel(0);
        } else {
            sap.setCertificationLevel(1);
        }
        try {
            stp.close();
        }
        catch (DocumentException ex) {
            return "e1004";
        }
        catch (IOException ex) {
            return "e1005";
        }
        catch (Exception e3) {
            if (e3.getLocalizedMessage().equalsIgnoreCase("The operation was canceled by the user.")) {
                return "failure";
            }
            return "failure";
        }
        return "success";
    }
}

