/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.pkcs11.SunPKCS11;
import util.Debug;
import util.KeyStoreEntry;
import util.OperatingSystem;

public class KeyStoreUtils {
    public static KeyStore getMSKeyStore() throws KeyStoreException {
        if (!OperatingSystem.isWindows()) {
            throw new KeyStoreException("Microsoft Key Store is only available on Windows platform.");
        }
        try {
            KeyStore MSKeyStore = KeyStore.getInstance("WINDOWS-MY", "SunMSCAPI");
            MSKeyStore.load(null, null);
            return MSKeyStore;
        }
        catch (Exception e2) {
            throw new KeyStoreException("Unable to open the Windows KeyStore. " + e2.getMessage(), e2);
        }
    }

    public static List<KeyStoreEntry> getTableEntries(KeyStore ks) throws KeyStoreException, CertificateException {
        try {
            if (ks == null) {
                throw new NullPointerException("KeyStoreUtils: getTableEntries: Unexpected null pointer for keystore");
            }
            ArrayList<KeyStoreEntry> entries = new ArrayList<KeyStoreEntry>();
            Enumeration<String> it = ks.aliases();
            while (it.hasMoreElements()) {
                String alias = it.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                entries.add(new KeyStoreEntry(ks, alias));
            }
            return entries;
        }
        catch (CertificateException e2) {
            throw new CertificateException(e2);
        }
        catch (Exception e3) {
            throw new KeyStoreException(e3);
        }
    }

    public static File getDefaultJKSKeyStore() throws KeyStoreException {
        String homeDirectory = System.getProperty("user.home");
        String defaultJKSName = ".keystore";
        File defaultJKSStore = new File(String.valueOf(homeDirectory) + "/" + defaultJKSName);
        if (!defaultJKSStore.exists()) {
            return null;
        }
        if (!defaultJKSStore.canRead()) {
            throw new KeyStoreException("Cannot read default JKS file " + defaultJKSStore.getAbsolutePath());
        }
        return defaultJKSStore;
    }

    public static KeyStore getJKSStore(File JKSFile, char[] password) throws KeyStoreException {
        try {
            if (!JKSFile.canRead()) {
                throw new KeyStoreException("Cannot read the file " + JKSFile.getAbsolutePath());
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = new FileInputStream(JKSFile);
            if (password == null) {
                ks.load(fis, null);
            } else {
                ks.load(fis, password);
            }
            return ks;
        }
        catch (IOException e2) {
            return null;
        }
        catch (Exception e3) {
            throw new KeyStoreException(e3);
        }
    }

    public static KeyStore getPKCS12Store(File PKCS12File, char[] password) throws KeyStoreException {
        try {
            if (!PKCS12File.canRead()) {
                throw new KeyStoreException("Cannot read the file " + PKCS12File.getAbsolutePath());
            }
            KeyStore ks = KeyStore.getInstance("PKCS12");
            FileInputStream fis = new FileInputStream(PKCS12File);
            if (password == null) {
                ks.load(fis, null);
            } else {
                ks.load(fis, password);
            }
            return ks;
        }
        catch (IOException e2) {
            return null;
        }
        catch (Exception e3) {
            throw new KeyStoreException(e3);
        }
    }

    public static KeyStore getPKCS11Store(File PKCS11LibFile, char[] password, String tokenName) throws KeyStoreException {
        try {
            if (!PKCS11LibFile.canRead()) {
                throw new KeyStoreException("Cannot read the file " + PKCS11LibFile.getAbsolutePath());
            }
            File PKCS11ConfigFile = File.createTempFile("pkcs11_config", "conf");
            Debug.println("config temp file" + PKCS11ConfigFile.getAbsolutePath());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(PKCS11ConfigFile)));
            writer.write(String.format("name = %s\n", tokenName));
            writer.write(String.format("library = %s\n", PKCS11LibFile.getPath()));
            writer.close();
            SunPKCS11 PKCS11SunProv = new SunPKCS11(PKCS11ConfigFile.getPath());
            KeyStore ks = KeyStore.getInstance("PKCS11", PKCS11SunProv);
            PKCS11ConfigFile.delete();
            if (password == null) {
                ks.load(null, null);
            } else {
                ks.load(null, password);
            }
            return ks;
        }
        catch (IOException e2) {
            return null;
        }
        catch (Exception e3) {
            throw new KeyStoreException(e3);
        }
    }
}

