/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_OUT;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class P11TlsKeyMaterialGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsKeyMaterialGenerator must be initialized using a TlsKeyMaterialParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private TlsKeyMaterialParameterSpec spec;
    private P11Key p11Key;
    private int version;

    P11TlsKeyMaterialGenerator(Token token, String string, long l2) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l2;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsKeyMaterialParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsKeyMaterialParameterSpec)algorithmParameterSpec;
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, this.spec.getMasterSecret(), "TlsMasterSecret");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.version < 768 && this.version > 770) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, and TLS 1.1 are supported");
        }
    }

    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        boolean bl;
        if (this.spec == null) {
            throw new IllegalStateException("TlsKeyMaterialGenerator must be initialized");
        }
        this.mechanism = this.version == 768 ? 882L : 886L;
        int n2 = this.spec.getMacKeyLength() << 3;
        int n3 = this.spec.getIvLength() << 3;
        int n4 = this.spec.getExpandedCipherKeyLength() << 3;
        int n5 = this.spec.getCipherKeyLength() << 3;
        if (n4 != 0) {
            bl = true;
        } else {
            bl = false;
            n4 = n5;
        }
        CK_SSL3_RANDOM_DATA cK_SSL3_RANDOM_DATA = new CK_SSL3_RANDOM_DATA(this.spec.getClientRandom(), this.spec.getServerRandom());
        CK_SSL3_KEY_MAT_PARAMS cK_SSL3_KEY_MAT_PARAMS = new CK_SSL3_KEY_MAT_PARAMS(n2, n5, n3, bl, cK_SSL3_RANDOM_DATA);
        String string = this.spec.getCipherAlgorithm();
        long l2 = P11SecretKeyFactory.getKeyType(string);
        if (l2 < 0L) {
            if (n5 != 0) {
                throw new ProviderException("Unknown algorithm: " + this.spec.getCipherAlgorithm());
            }
            l2 = 16L;
        }
        Session session = null;
        try {
            SecretKey secretKey;
            SecretKey secretKey2;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = n5 != 0 ? new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l2), new CK_ATTRIBUTE(353L, n4 >> 3)} : new CK_ATTRIBUTE[]{};
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, l2, cK_ATTRIBUTEArray);
            long l3 = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, cK_SSL3_KEY_MAT_PARAMS), this.p11Key.keyID, cK_ATTRIBUTEArray);
            CK_SSL3_KEY_MAT_OUT cK_SSL3_KEY_MAT_OUT = cK_SSL3_KEY_MAT_PARAMS.pReturnedKeyMaterial;
            SecretKey secretKey3 = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hClientMacSecret, "MAC", n2, cK_ATTRIBUTEArray);
            SecretKey secretKey4 = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hServerMacSecret, "MAC", n2, cK_ATTRIBUTEArray);
            if (n5 != 0) {
                secretKey2 = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hClientKey, string, n4, cK_ATTRIBUTEArray);
                secretKey = P11Key.secretKey(session, cK_SSL3_KEY_MAT_OUT.hServerKey, string, n4, cK_ATTRIBUTEArray);
            } else {
                secretKey2 = null;
                secretKey = null;
            }
            IvParameterSpec ivParameterSpec = cK_SSL3_KEY_MAT_OUT.pIVClient == null ? null : new IvParameterSpec(cK_SSL3_KEY_MAT_OUT.pIVClient);
            IvParameterSpec ivParameterSpec2 = cK_SSL3_KEY_MAT_OUT.pIVServer == null ? null : new IvParameterSpec(cK_SSL3_KEY_MAT_OUT.pIVServer);
            TlsKeyMaterialSpec tlsKeyMaterialSpec = new TlsKeyMaterialSpec(secretKey3, secretKey4, secretKey2, ivParameterSpec, secretKey, ivParameterSpec2);
            return tlsKeyMaterialSpec;
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key", exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

