/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jce.provider.PKIXNameConstraints;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator<PKIXCertPathChecker> iterator;
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Set<String> set;
        PublicKey publicKey;
        X500Principal x500Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n3 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = CertPathValidatorUtilities.getValidDate(pKIXParameters);
        Set<String> set2 = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = CertPathValidatorUtilities.findTrustAnchor((X509Certificate)list.get(list.size() - 1), certPath, list.size() - 1, pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found.", null, certPath, -1);
        }
        int n4 = 0;
        List[] listArray = new ArrayList[n3 + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), ANY_POLICY, false);
        listArray[0].add(pKIXPolicyNode);
        PKIXNameConstraints pKIXNameConstraints = new PKIXNameConstraints();
        HashSet hashSet2 = null;
        int n5 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n3 + 1;
        int n6 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n3 + 1;
        int n7 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n3 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = CertPathValidatorUtilities.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n8 = n3;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        List<PKIXCertPathChecker> list2 = pKIXParameters.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n4 = list.size() - 1; n4 >= 0; --n4) {
            try {
                PKIXPolicyNode pKIXPolicyNode2;
                Object object5;
                Object object6;
                int n9;
                Set<String> set3;
                int n10 = n3 - n4;
                x509Certificate2 = (X509Certificate)list.get(n4);
                try {
                    x509Certificate2.verify(publicKey, "BC");
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)generalSecurityException, certPath, n4);
                }
                try {
                    x509Certificate2.checkValidity(date);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    throw new CertPathValidatorException("Could not validate certificate: " + certificateExpiredException.getMessage(), (Throwable)certificateExpiredException, certPath, n4);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    throw new CertPathValidatorException("Could not validate certificate: " + certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException, certPath, n4);
                }
                if (pKIXParameters.isRevocationEnabled()) {
                    this.checkCRLs(pKIXParameters, x509Certificate2, date, x509Certificate, publicKey);
                }
                if (!CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate2).equals(x500Principal)) {
                    throw new CertPathValidatorException("IssuerName(" + CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate2) + ") does not match SubjectName(" + x500Principal + ") of signing certificate", null, certPath, n4);
                }
                if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate2) || n10 >= n3) {
                    set = CertPathValidatorUtilities.getSubjectPrincipal(x509Certificate2);
                    object4 = new ASN1InputStream(((X500Principal)((Object)set)).getEncoded());
                    try {
                        object3 = (ASN1Sequence)((ASN1InputStream)object4).readObject();
                    }
                    catch (IOException iOException) {
                        throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                    }
                    pKIXNameConstraints.checkPermittedDN((ASN1Sequence)object3);
                    pKIXNameConstraints.checkExcludedDN((ASN1Sequence)object3);
                    set3 = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                    if (set3 != null) {
                        for (n9 = 0; n9 < ((ASN1Sequence)((Object)set3)).size(); n9 += 1) {
                            object6 = GeneralName.getInstance(((ASN1Sequence)((Object)set3)).getObjectAt(n9));
                            pKIXNameConstraints.checkPermitted((GeneralName)object6);
                            pKIXNameConstraints.checkExcluded((GeneralName)object6);
                        }
                    }
                }
                if ((set = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                    int n11;
                    object4 = ((ASN1Sequence)((Object)set)).getObjects();
                    object3 = new HashSet();
                    while (object4.hasMoreElements()) {
                        set3 = PolicyInformation.getInstance(object4.nextElement());
                        DERObjectIdentifier dERObjectIdentifier2 = ((PolicyInformation)((Object)set3)).getPolicyIdentifier();
                        object3.add(dERObjectIdentifier2.getId());
                        if (ANY_POLICY.equals(dERObjectIdentifier2.getId()) || (n11 = CertPathValidatorUtilities.processCertD1i(n10, listArray, dERObjectIdentifier2, (Set)(object6 = CertPathValidatorUtilities.getQualifierSet(((PolicyInformation)((Object)set3)).getPolicyQualifiers())))) != 0) continue;
                        CertPathValidatorUtilities.processCertD1ii(n10, listArray, dERObjectIdentifier2, (Set)object6);
                    }
                    if (hashSet2 == null || hashSet2.contains(ANY_POLICY)) {
                        hashSet2 = object3;
                    } else {
                        set3 = hashSet2.iterator();
                        HashSet<Object> hashSet3 = new HashSet<Object>();
                        while (set3.hasNext()) {
                            object6 = set3.next();
                            if (!object3.contains(object6)) continue;
                            hashSet3.add(object6);
                        }
                        hashSet2 = hashSet3;
                    }
                    if (n6 > 0 || n10 < n3 && CertPathValidatorUtilities.isSelfIssued(x509Certificate2)) {
                        object4 = ((ASN1Sequence)((Object)set)).getObjects();
                        while (object4.hasMoreElements()) {
                            set3 = PolicyInformation.getInstance(object4.nextElement());
                            if (!ANY_POLICY.equals(((PolicyInformation)((Object)set3)).getPolicyIdentifier().getId())) continue;
                            Set set4 = CertPathValidatorUtilities.getQualifierSet(((PolicyInformation)((Object)set3)).getPolicyQualifiers());
                            object6 = listArray[n10 - 1];
                            for (n11 = 0; n11 < object6.size(); ++n11) {
                                object2 = (PKIXPolicyNode)object6.get(n11);
                                object = ((PKIXPolicyNode)object2).getExpectedPolicies().iterator();
                                while (object.hasNext()) {
                                    Object object7;
                                    String string;
                                    object5 = object.next();
                                    if (object5 instanceof String) {
                                        string = (String)object5;
                                    } else {
                                        if (!(object5 instanceof DERObjectIdentifier)) continue;
                                        string = ((DERObjectIdentifier)object5).getId();
                                    }
                                    boolean bl = false;
                                    Iterator iterator3 = ((PKIXPolicyNode)object2).getChildren();
                                    while (iterator3.hasNext()) {
                                        object7 = (PKIXPolicyNode)iterator3.next();
                                        if (!string.equals(((PKIXPolicyNode)object7).getValidPolicy())) continue;
                                        bl = true;
                                    }
                                    if (bl) continue;
                                    object7 = new HashSet();
                                    object7.add(string);
                                    pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n10, (Set)object7, (PolicyNode)object2, set4, string, false);
                                    ((PKIXPolicyNode)object2).addChild(pKIXPolicyNode2);
                                    listArray[n10].add(pKIXPolicyNode2);
                                }
                            }
                        }
                    }
                    for (int i3 = n10 - 1; i3 >= 0; --i3) {
                        PKIXPolicyNode pKIXPolicyNode3;
                        List list3 = listArray[i3];
                        for (int i4 = 0; i4 < list3.size() && ((pKIXPolicyNode3 = (PKIXPolicyNode)list3.get(i4)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3)) != null); ++i4) {
                        }
                    }
                    set3 = x509Certificate2.getCriticalExtensionOIDs();
                    if (set3 != null) {
                        n9 = set3.contains(CERTIFICATE_POLICIES) ? 1 : 0;
                        List list4 = listArray[n10];
                        for (int i5 = 0; i5 < list4.size(); ++i5) {
                            object2 = (PKIXPolicyNode)list4.get(i5);
                            ((PKIXPolicyNode)object2).setCritical(n9 != 0);
                        }
                    }
                }
                if (set == null) {
                    pKIXPolicyNode = null;
                }
                if (n5 <= 0 && pKIXPolicyNode == null) {
                    throw new CertPathValidatorException("No valid policy tree found when one expected.");
                }
                if (n10 != n3) {
                    boolean[] blArray;
                    int n12;
                    BigInteger bigInteger;
                    BasicConstraints basicConstraints;
                    int n13;
                    DERInteger dERInteger;
                    if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                        throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                    }
                    object4 = CertPathValidatorUtilities.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                    if (object4 != null) {
                        object3 = (ASN1Sequence)object4;
                        for (int i6 = 0; i6 < ((ASN1Sequence)object3).size(); ++i6) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object3).getObjectAt(i6);
                            DERObjectIdentifier dERObjectIdentifier3 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
                            DERObjectIdentifier dERObjectIdentifier4 = (DERObjectIdentifier)aSN1Sequence.getObjectAt(1);
                            if (ANY_POLICY.equals(dERObjectIdentifier3.getId())) {
                                throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                            }
                            if (!ANY_POLICY.equals(dERObjectIdentifier4.getId())) continue;
                            throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                        }
                    }
                    if (object4 != null) {
                        object3 = (ASN1Sequence)object4;
                        HashMap<HashSet<String>, Object> hashMap = new HashMap<HashSet<String>, Object>();
                        HashSet<HashSet<String>> hashSet4 = new HashSet<HashSet<String>>();
                        for (int i7 = 0; i7 < ((ASN1Sequence)object3).size(); ++i7) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object3).getObjectAt(i7);
                            object2 = ((DERObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
                            object = ((DERObjectIdentifier)aSN1Sequence.getObjectAt(1)).getId();
                            if (!hashMap.containsKey(object2)) {
                                object5 = new HashSet();
                                object5.add(object);
                                hashMap.put((HashSet<String>)object2, object5);
                                hashSet4.add((HashSet<String>)object2);
                                continue;
                            }
                            object5 = (Set)hashMap.get(object2);
                            object5.add(object);
                        }
                        Iterator iterator4 = hashSet4.iterator();
                        block41: while (iterator4.hasNext()) {
                            Object object8;
                            String string = (String)iterator4.next();
                            if (n7 > 0) {
                                boolean bl = false;
                                object = listArray[n10].iterator();
                                while (object.hasNext()) {
                                    object5 = (PKIXPolicyNode)object.next();
                                    if (!((PKIXPolicyNode)object5).getValidPolicy().equals(string)) continue;
                                    bl = true;
                                    ((PKIXPolicyNode)object5).expectedPolicies = (Set)hashMap.get(string);
                                    break;
                                }
                                if (bl) continue;
                                object = listArray[n10].iterator();
                                while (object.hasNext()) {
                                    object5 = (PKIXPolicyNode)object.next();
                                    if (!ANY_POLICY.equals(((PKIXPolicyNode)object5).getValidPolicy())) continue;
                                    Set set5 = null;
                                    object8 = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES);
                                    Enumeration enumeration = ((ASN1Sequence)object8).getObjects();
                                    while (enumeration.hasMoreElements()) {
                                        PolicyInformation policyInformation = PolicyInformation.getInstance(enumeration.nextElement());
                                        if (!ANY_POLICY.equals(policyInformation.getPolicyIdentifier().getId())) continue;
                                        set5 = CertPathValidatorUtilities.getQualifierSet(policyInformation.getPolicyQualifiers());
                                        break;
                                    }
                                    boolean bl2 = false;
                                    if (x509Certificate2.getCriticalExtensionOIDs() != null) {
                                        bl2 = x509Certificate2.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                                    }
                                    if (!ANY_POLICY.equals((pKIXPolicyNode2 = (PKIXPolicyNode)((PKIXPolicyNode)object5).getParent()).getValidPolicy())) continue block41;
                                    PKIXPolicyNode pKIXPolicyNode4 = new PKIXPolicyNode(new ArrayList(), n10, (Set)hashMap.get(string), pKIXPolicyNode2, set5, string, bl2);
                                    pKIXPolicyNode2.addChild(pKIXPolicyNode4);
                                    listArray[n10].add(pKIXPolicyNode4);
                                    continue block41;
                                }
                                continue;
                            }
                            if (n7 > 0) continue;
                            Iterator iterator5 = listArray[n10].iterator();
                            while (iterator5.hasNext()) {
                                object = (PKIXPolicyNode)iterator5.next();
                                if (!((PKIXPolicyNode)object).getValidPolicy().equals(string)) continue;
                                object5 = (PKIXPolicyNode)((PKIXPolicyNode)object).getParent();
                                ((PKIXPolicyNode)object5).removeChild((PKIXPolicyNode)object);
                                iterator5.remove();
                                for (int i8 = n10 - 1; i8 >= 0; --i8) {
                                    PKIXPolicyNode pKIXPolicyNode5;
                                    object8 = listArray[i8];
                                    for (int i9 = 0; i9 < object8.size() && ((pKIXPolicyNode5 = (PKIXPolicyNode)object8.get(i9)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode5)) != null); ++i9) {
                                    }
                                }
                            }
                        }
                    }
                    if ((object3 = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                        ASN1Sequence aSN1Sequence;
                        NameConstraints nameConstraints = new NameConstraints((ASN1Sequence)object3);
                        ASN1Sequence aSN1Sequence2 = nameConstraints.getPermittedSubtrees();
                        if (aSN1Sequence2 != null) {
                            Enumeration enumeration = aSN1Sequence2.getObjects();
                            while (enumeration.hasMoreElements()) {
                                GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                                pKIXNameConstraints.intersectPermittedSubtree(generalSubtree);
                            }
                        }
                        if ((aSN1Sequence = nameConstraints.getExcludedSubtrees()) != null) {
                            Enumeration enumeration = aSN1Sequence.getObjects();
                            while (enumeration.hasMoreElements()) {
                                GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                                pKIXNameConstraints.addExcludedSubtree(generalSubtree);
                            }
                        }
                    }
                    if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate2)) {
                        if (n5 != 0) {
                            --n5;
                        }
                        if (n7 != 0) {
                            --n7;
                        }
                        if (n6 != 0) {
                            --n6;
                        }
                    }
                    if ((set3 = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                        Enumeration enumeration = ((ASN1Sequence)((Object)set3)).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    n2 = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n2 >= n5) break;
                                    n5 = n2;
                                    break;
                                }
                                case 1: {
                                    n2 = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                    if (n2 >= n7) break;
                                    n7 = n2;
                                }
                            }
                        }
                    }
                    if ((dERInteger = (DERInteger)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n13 = dERInteger.getValue().intValue()) < n6) {
                        n6 = n13;
                    }
                    if ((basicConstraints = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                        if (!basicConstraints.isCA()) {
                            throw new CertPathValidatorException("Not a CA certificate");
                        }
                    } else {
                        throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                    }
                    if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate2)) {
                        if (n8 <= 0) {
                            throw new CertPathValidatorException("Max path length not greater than zero");
                        }
                        --n8;
                    }
                    if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n12 = bigInteger.intValue()) < n8) {
                        n8 = n12;
                    }
                    if ((blArray = x509Certificate2.getKeyUsage()) != null && !blArray[5]) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n4);
                    }
                    object2 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                    object2.remove(KEY_USAGE);
                    object2.remove(CERTIFICATE_POLICIES);
                    object2.remove(POLICY_MAPPINGS);
                    object2.remove(INHIBIT_ANY_POLICY);
                    object2.remove(ISSUING_DISTRIBUTION_POINT);
                    object2.remove(DELTA_CRL_INDICATOR);
                    object2.remove(POLICY_CONSTRAINTS);
                    object2.remove(BASIC_CONSTRAINTS);
                    object2.remove(SUBJECT_ALTERNATIVE_NAME);
                    object2.remove(NAME_CONSTRAINTS);
                    iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        try {
                            iterator.next().check(x509Certificate2, (Collection<String>)object2);
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n4);
                        }
                    }
                    if (!object2.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n4);
                    }
                }
                x509Certificate = x509Certificate2;
                publicKey = CertPathValidatorUtilities.getNextWorkingKey(x509Certificate, list, n4);
                try {
                    x500Principal = CertPathValidatorUtilities.getSubjectPrincipal(x509Certificate);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + illegalArgumentException.toString());
                }
                algorithmIdentifier = CertPathValidatorUtilities.getAlgorithmIdentifier(publicKey);
                dERObjectIdentifier = algorithmIdentifier.getObjectId();
                dEREncodable = algorithmIdentifier.getParameters();
                continue;
            }
            catch (AnnotatedException annotatedException) {
                throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n4);
            }
        }
        if (!CertPathValidatorUtilities.isSelfIssued(x509Certificate2) && n5 != 0) {
            --n5;
        }
        try {
            set = (ASN1Sequence)CertPathValidatorUtilities.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS);
            if (set != null) {
                object4 = ((ASN1Sequence)((Object)set)).getObjects();
                while (object4.hasMoreElements()) {
                    object3 = (ASN1TaggedObject)object4.nextElement();
                    switch (((ASN1TaggedObject)object3).getTagNo()) {
                        case 0: {
                            n2 = DERInteger.getInstance(object3).getValue().intValue();
                            if (n2 != 0) break;
                            n5 = 0;
                        }
                    }
                }
            }
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n4);
        }
        set = x509Certificate2.getCriticalExtensionOIDs();
        if (set != null) {
            set = new HashSet(set);
            set.remove(KEY_USAGE);
            set.remove(CERTIFICATE_POLICIES);
            set.remove(POLICY_MAPPINGS);
            set.remove(INHIBIT_ANY_POLICY);
            set.remove(ISSUING_DISTRIBUTION_POINT);
            set.remove(DELTA_CRL_INDICATOR);
            set.remove(POLICY_CONSTRAINTS);
            set.remove(BASIC_CONSTRAINTS);
            set.remove(SUBJECT_ALTERNATIVE_NAME);
            set.remove(NAME_CONSTRAINTS);
        } else {
            set = new HashSet<String>();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().check(x509Certificate2, set);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n4);
            }
        }
        if (!set.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n4);
        }
        if (pKIXPolicyNode == null) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.");
            }
            object4 = null;
        } else if (CertPathValidatorUtilities.isAnyPolicy(set2)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet2.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.");
                }
                object3 = new HashSet();
                for (int i10 = 0; i10 < listArray.length; ++i10) {
                    ArrayList arrayList = listArray[i10];
                    for (int i11 = 0; i11 < arrayList.size(); ++i11) {
                        PKIXPolicyNode pKIXPolicyNode6 = (PKIXPolicyNode)arrayList.get(i11);
                        if (!ANY_POLICY.equals(pKIXPolicyNode6.getValidPolicy())) continue;
                        object2 = pKIXPolicyNode6.getChildren();
                        while (object2.hasNext()) {
                            object3.add(object2.next());
                        }
                    }
                }
                Iterator iterator6 = object3.iterator();
                while (iterator6.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)iterator6.next();
                    String string = pKIXPolicyNode7.getValidPolicy();
                    if (hashSet2.contains(string)) continue;
                }
                if (pKIXPolicyNode != null) {
                    for (int i12 = n3 - 1; i12 >= 0; --i12) {
                        List list5 = listArray[i12];
                        for (int i13 = 0; i13 < list5.size(); ++i13) {
                            object2 = (PKIXPolicyNode)list5.get(i13);
                            if (((PKIXPolicyNode)object2).hasChildren()) continue;
                            pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object2);
                        }
                    }
                }
            }
            object4 = pKIXPolicyNode;
        } else {
            object3 = new HashSet();
            for (int i14 = 0; i14 < listArray.length; ++i14) {
                ArrayList arrayList = listArray[i14];
                for (int i15 = 0; i15 < arrayList.size(); ++i15) {
                    PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)arrayList.get(i15);
                    if (!ANY_POLICY.equals(pKIXPolicyNode8.getValidPolicy())) continue;
                    object2 = pKIXPolicyNode8.getChildren();
                    while (object2.hasNext()) {
                        object = (PKIXPolicyNode)object2.next();
                        if (ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) continue;
                        object3.add(object);
                    }
                }
            }
            Iterator iterator7 = object3.iterator();
            while (iterator7.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode9 = (PKIXPolicyNode)iterator7.next();
                String string = pKIXPolicyNode9.getValidPolicy();
                if (set2.contains(string)) continue;
                pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode9);
            }
            if (pKIXPolicyNode != null) {
                for (int i16 = n3 - 1; i16 >= 0; --i16) {
                    ArrayList arrayList = listArray[i16];
                    for (int i17 = 0; i17 < arrayList.size(); ++i17) {
                        object2 = (PKIXPolicyNode)arrayList.get(i17);
                        if (((PKIXPolicyNode)object2).hasChildren()) continue;
                        pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object2);
                    }
                }
            }
            object4 = pKIXPolicyNode;
        }
        if (n5 > 0 || object4 != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object4, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n4);
    }

    private void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey) throws AnnotatedException {
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(CertPathValidatorUtilities.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from certificate: " + iOException, iOException);
        }
        x509CRLSelector.setCertificateChecking(x509Certificate);
        Iterator iterator = CertPathValidatorUtilities.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            X509CRL x509CRL = (X509CRL)iterator.next();
            if (!x509Certificate.getNotAfter().after(x509CRL.getThisUpdate())) continue;
            if (x509CRL.getNextUpdate() == null || date.before(x509CRL.getNextUpdate())) {
                bl = true;
            }
            if (!(x509Certificate2 == null || (object3 = x509Certificate2.getKeyUsage()) == null || ((boolean[])object3).length >= 7 && object3[6])) {
                throw new AnnotatedException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate2);
            }
            try {
                x509CRL.verify(publicKey, "BC");
            }
            catch (Exception exception) {
                throw new AnnotatedException("can't verify CRL: " + exception, exception);
            }
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate.getSerialNumber());
            if (x509CRLEntry != null && !date.before(x509CRLEntry.getRevocationDate())) {
                object3 = null;
                if (x509CRLEntry.hasExtensions() && (object2 = DEREnumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRLEntry, X509Extensions.ReasonCode.getId()))) != null) {
                    object3 = crlReasons[((DEREnumerated)object2).getValue().intValue()];
                }
                object2 = "Certificate revocation after " + x509CRLEntry.getRevocationDate();
                if (object3 != null) {
                    object2 = (String)object2 + ", reason: " + (String)object3;
                }
                throw new AnnotatedException((String)object2);
            }
            object3 = CertPathValidatorUtilities.getExtensionValue(x509CRL, ISSUING_DISTRIBUTION_POINT);
            object2 = CertPathValidatorUtilities.getExtensionValue(x509CRL, DELTA_CRL_INDICATOR);
            if (object2 != null) {
                object = new X509CRLSelector();
                try {
                    ((X509CRLSelector)object).addIssuerName(CertPathValidatorUtilities.getIssuerPrincipal(x509CRL).getEncoded());
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("can't extract issuer from certificate: " + iOException, iOException);
                }
                ((X509CRLSelector)object).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                ((X509CRLSelector)object).setMaxCRLNumber(((DERInteger)CertPathValidatorUtilities.getExtensionValue(x509CRL, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                boolean bl2 = false;
                Iterator iterator2 = CertPathValidatorUtilities.findCRLs((X509CRLSelector)object, pKIXParameters.getCertStores()).iterator();
                while (iterator2.hasNext()) {
                    X509CRL x509CRL2 = (X509CRL)iterator2.next();
                    DERObject dERObject = CertPathValidatorUtilities.getExtensionValue(x509CRL2, ISSUING_DISTRIBUTION_POINT);
                    if (object3 == null) {
                        if (dERObject != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!((DERObject)object3).equals(dERObject)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new AnnotatedException("No base CRL for delta CRL");
                }
            }
            if (object3 == null) continue;
            object = IssuingDistributionPoint.getInstance(object3);
            BasicConstraints basicConstraints = BasicConstraints.getInstance(CertPathValidatorUtilities.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            if (((IssuingDistributionPoint)object).onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                throw new AnnotatedException("CA Cert CRL only contains user certificates");
            }
            if (((IssuingDistributionPoint)object).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                throw new AnnotatedException("End CRL only contains CA certificates");
            }
            if (!((IssuingDistributionPoint)object).onlyContainsAttributeCerts()) continue;
            throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted");
        }
        if (!bl) {
            throw new AnnotatedException("no valid CRL found");
        }
    }
}

