/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.zip;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.zip.AbstractZip;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.util.JRLoader;

public class FileBufferedZip
extends AbstractZip {
    private final Integer memoryThreshold;

    public FileBufferedZip() {
        this(null);
    }

    public FileBufferedZip(Integer memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @Override
    public ExportZipEntry createEntry(String name) {
        return this.memoryThreshold == null ? new FileBufferedZipEntry(name) : new FileBufferedZipEntry(name, this.memoryThreshold);
    }

    public void addEntry(String name, String resource) {
        try {
            this.addEntry(new FileBufferedZipEntry(name, JRLoader.loadBytesFromResource(resource)));
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }
}

