/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;

public class JRPrintServiceExporter
extends JRAbstractExporter
implements Printable {
    protected JRGraphics2DExporter exporter;
    protected boolean displayPageDialog;
    protected boolean displayPageDialogOnlyOnce;
    protected boolean displayPrintDialog;
    protected boolean displayPrintDialogOnlyOnce;
    protected int reportIndex;
    private PrintService printService;
    private Boolean[] printStatus;

    public JRPrintServiceExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPrintServiceExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        this.setOffset();
        try {
            PrintService[] services;
            Boolean printDialog;
            Boolean pageDialog;
            PrintServiceAttributeSet printServiceAttributeSet;
            this.setExportContext();
            this.setInput();
            if (!this.isModeBatch) {
                this.setPageRange();
            }
            if ((printServiceAttributeSet = (PrintServiceAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET)) == null) {
                printServiceAttributeSet = new HashPrintServiceAttributeSet();
            }
            if ((pageDialog = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG)) != null) {
                this.displayPageDialog = pageDialog;
            }
            Boolean pageDialogOnlyOnce = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG_ONLY_ONCE);
            if (this.displayPageDialog && pageDialogOnlyOnce != null) {
                this.displayPageDialogOnlyOnce = pageDialogOnlyOnce;
            }
            if ((printDialog = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG)) != null) {
                this.displayPrintDialog = printDialog;
            }
            Boolean printDialogOnlyOnce = (Boolean)this.parameters.get(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG_ONLY_ONCE);
            if (this.displayPrintDialog && printDialogOnlyOnce != null) {
                this.displayPrintDialogOnlyOnce = printDialogOnlyOnce;
            }
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            JRPrinterAWT.initPrinterJobFields(printerJob);
            printerJob.setPrintable(this);
            this.printStatus = null;
            this.printService = (PrintService)this.parameters.get(JRPrintServiceExporterParameter.PRINT_SERVICE);
            if (this.printService == null && (services = PrintServiceLookup.lookupPrintServices(null, printServiceAttributeSet)).length > 0) {
                this.printService = services[0];
            }
            if (this.printService == null) {
                throw new JRException("No suitable print service found.");
            }
            try {
                printerJob.setPrintService(this.printService);
            }
            catch (PrinterException e2) {
                throw new JRException(e2);
            }
            HashPrintRequestAttributeSet printRequestAttributeSet = null;
            if (this.displayPrintDialogOnlyOnce || this.displayPageDialogOnlyOnce) {
                printRequestAttributeSet = new HashPrintRequestAttributeSet();
                this.setDefaultPrintRequestAttributeSet(printRequestAttributeSet);
                this.setOrientation((JasperPrint)this.jasperPrintList.get(0), printRequestAttributeSet);
                if (this.displayPageDialogOnlyOnce) {
                    if (printerJob.pageDialog(printRequestAttributeSet) == null) {
                        return;
                    }
                    this.displayPageDialog = false;
                }
                if (this.displayPrintDialogOnlyOnce) {
                    if (!printerJob.printDialog(printRequestAttributeSet)) {
                        this.printStatus = new Boolean[]{Boolean.FALSE};
                        return;
                    }
                    this.displayPrintDialog = false;
                }
            }
            ArrayList<Boolean> status = new ArrayList<Boolean>();
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
                this.exporter = new JRGraphics2DExporter(this.jasperReportsContext);
                this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
                this.exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, this.parameters.get(JRExporterParameter.PROGRESS_MONITOR));
                this.exporter.setParameter(JRExporterParameter.OFFSET_X, this.parameters.get(JRExporterParameter.OFFSET_X));
                this.exporter.setParameter(JRExporterParameter.OFFSET_Y, this.parameters.get(JRExporterParameter.OFFSET_Y));
                this.exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO));
                if (this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.exporter.setParameter(JRExporterParameter.FILTER, this.filter);
                }
                this.exporter.setParameter(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE, this.parameters.get(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE));
                if (this.displayPrintDialog || this.displayPageDialog || !this.displayPrintDialogOnlyOnce && !this.displayPageDialogOnlyOnce) {
                    printRequestAttributeSet = new HashPrintRequestAttributeSet();
                    this.setDefaultPrintRequestAttributeSet(printRequestAttributeSet);
                    this.setOrientation(this.jasperPrint, printRequestAttributeSet);
                }
                try {
                    if (!this.isModeBatch) {
                        printRequestAttributeSet.add(new PageRanges(this.startPageIndex + 1, this.endPageIndex + 1));
                    }
                    printerJob.setJobName("JasperReports - " + this.jasperPrint.getName());
                    if (this.displayPageDialog) {
                        printerJob.pageDialog(printRequestAttributeSet);
                    }
                    if (this.displayPrintDialog) {
                        if (printerJob.printDialog(printRequestAttributeSet)) {
                            status.add(Boolean.TRUE);
                            printerJob.print(printRequestAttributeSet);
                        } else {
                            status.add(Boolean.FALSE);
                        }
                    } else {
                        PageFormat pageFormat = printerJob.defaultPage();
                        Paper paper = pageFormat.getPaper();
                        switch (this.jasperPrint.getOrientationValue()) {
                            case LANDSCAPE: {
                                pageFormat.setOrientation(0);
                                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                                break;
                            }
                            default: {
                                pageFormat.setOrientation(1);
                                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                            }
                        }
                        pageFormat.setPaper(paper);
                        printerJob.setPrintable(this, pageFormat);
                        printerJob.print(printRequestAttributeSet);
                    }
                }
                catch (PrinterException e3) {
                    throw new JRException(e3);
                }
                ++this.reportIndex;
            }
            this.printStatus = status.toArray(new Boolean[status.size()]);
            this.printService = printerJob.getPrintService();
        }
        finally {
            this.resetExportContext();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.interrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if (pageIndex < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics);
        this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, pageIndex);
        try {
            this.exporter.exportReport();
        }
        catch (JRException e2) {
            throw new PrinterException(e2.getMessage());
        }
        return 0;
    }

    private void setOrientation(JasperPrint jPrint, PrintRequestAttributeSet printRequestAttributeSet) {
        if (!printRequestAttributeSet.containsKey(MediaPrintableArea.class)) {
            int printableHeight;
            int printableWidth;
            switch (jPrint.getOrientationValue()) {
                case LANDSCAPE: {
                    printableWidth = jPrint.getPageHeight();
                    printableHeight = jPrint.getPageWidth();
                    break;
                }
                default: {
                    printableWidth = jPrint.getPageWidth();
                    printableHeight = jPrint.getPageHeight();
                }
            }
            printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, (float)printableWidth / 72.0f, (float)printableHeight / 72.0f, 25400));
        }
        if (!printRequestAttributeSet.containsKey(OrientationRequested.class)) {
            OrientationRequested orientation;
            switch (jPrint.getOrientationValue()) {
                case LANDSCAPE: {
                    orientation = OrientationRequested.LANDSCAPE;
                    break;
                }
                default: {
                    orientation = OrientationRequested.PORTRAIT;
                }
            }
            printRequestAttributeSet.add(orientation);
        }
    }

    private void setDefaultPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        PrintRequestAttributeSet printRequestAttributeSetParam = (PrintRequestAttributeSet)this.parameters.get(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET);
        if (printRequestAttributeSetParam != null) {
            printRequestAttributeSet.addAll(printRequestAttributeSetParam);
        }
    }

    public static boolean checkAvailablePrinters() {
        PrintService[] ss = PrinterJob.lookupPrintServices();
        for (int i2 = 0; i2 < ss.length; ++i2) {
            Attribute[] att = ss[i2].getAttributes().toArray();
            for (int j2 = 0; j2 < att.length; ++j2) {
                if (!att[j2].equals(PrinterIsAcceptingJobs.ACCEPTING_JOBS)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean[] getPrintStatus() {
        return this.printStatus;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    @Override
    protected String getExporterKey() {
        return null;
    }
}

