/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.components.map.fill.FillContextProvider;
import net.sf.jasperreports.components.map.fill.FillItemData;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class MapFillComponent
extends BaseFillComponent
implements FillContextProvider {
    private final MapComponent mapComponent;
    private Float latitude;
    private Float longitude;
    private Integer zoom;
    private String language;
    private MapTypeEnum mapType;
    private MapScaleEnum mapScale;
    private MapImageTypeEnum imageType;
    private FillItemData markerData;
    private List<Map<String, Object>> markers;
    JRFillObjectFactory factory;

    public MapFillComponent(MapComponent map) {
        this.mapComponent = map;
    }

    public MapFillComponent(MapComponent map, JRFillObjectFactory factory) {
        this.mapComponent = map;
        this.factory = factory;
        if (this.mapComponent.getMarkerData() != null) {
            this.markerData = new FillItemData(this, this.mapComponent.getMarkerData(), factory);
        }
    }

    protected MapComponent getMap() {
        return this.mapComponent;
    }

    @Override
    public FillContext getFillContext() {
        return this.fillContext;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateMap(evaluation);
        }
    }

    protected void evaluateMap(byte evaluation) throws JRException {
        this.latitude = (Float)this.fillContext.evaluate(this.mapComponent.getLatitudeExpression(), evaluation);
        this.longitude = (Float)this.fillContext.evaluate(this.mapComponent.getLongitudeExpression(), evaluation);
        this.zoom = (Integer)this.fillContext.evaluate(this.mapComponent.getZoomExpression(), evaluation);
        Integer n2 = this.zoom = this.zoom == null ? MapComponent.DEFAULT_ZOOM : this.zoom;
        if (this.mapComponent.getLanguageExpression() != null) {
            this.language = (String)this.fillContext.evaluate(this.mapComponent.getLanguageExpression(), evaluation);
        } else {
            Locale locale = this.fillContext.getReportLocale();
            if (locale != null) {
                this.language = locale.getLanguage();
            }
        }
        this.mapType = this.mapComponent.getMapType() == null ? MapTypeEnum.ROADMAP : this.mapComponent.getMapType();
        this.mapScale = this.mapComponent.getMapScale();
        this.imageType = this.mapComponent.getImageType();
        if (this.mapComponent.getMarkerData() != null) {
            this.markers = this.markerData.getEvaluateItems(evaluation);
        }
    }

    protected boolean isEvaluateNow() {
        return this.mapComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), MapPrintElement.MAP_ELEMENT_TYPE);
        template = this.deduplicate(template);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.elementId);
        printElement.setUUID(element.getUUID());
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy(printElement);
        } else {
            this.fillContext.registerDelayedEvaluation(printElement, this.mapComponent.getEvaluationTime(), this.mapComponent.getEvaluationGroup());
        }
        return printElement;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateMap(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("latitude", this.latitude);
        printElement.setParameterValue("longitude", this.longitude);
        printElement.setParameterValue("zoom", this.zoom);
        if (this.language != null) {
            printElement.setParameterValue("language", this.language);
        }
        if (this.mapType != null) {
            printElement.setParameterValue("mapType", this.mapType.getName());
        }
        if (this.mapScale != null) {
            printElement.setParameterValue("mapScale", this.mapScale.getName());
        }
        if (this.imageType != null) {
            printElement.setParameterValue("imageType", this.imageType.getName());
        }
        if (this.markers != null && !this.markers.isEmpty()) {
            printElement.setParameterValue("markers", this.markers);
        }
    }
}

