/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.components.headertoolbar.actions.MoveElementCommand;
import net.sf.jasperreports.components.headertoolbar.actions.ResizeColumnData;
import net.sf.jasperreports.components.headertoolbar.actions.ResizeElementCommand;
import net.sf.jasperreports.components.headertoolbar.actions.SimpleResizeColumnCommand;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;

public class ResizeColumnCommand
implements Command {
    private StandardTable table;
    private ResizeColumnData resizeColumnData;
    private CommandStack individualResizeCommandStack;

    public ResizeColumnCommand(StandardTable table, ResizeColumnData resizeColumnData) {
        this.table = table;
        this.resizeColumnData = resizeColumnData;
        this.individualResizeCommandStack = new CommandStack();
    }

    @Override
    public void execute() throws CommandException {
        List<BaseColumn> tableColumns = TableUtil.getAllColumns(this.table);
        int modIndex = this.resizeColumnData.getColumnIndex();
        StandardColumn modColumn = (StandardColumn)tableColumns.get(modIndex);
        int deltaWidth = this.resizeColumnData.getWidth() - modColumn.getWidth();
        int startX = 0;
        List<BaseColumn> allColumns = TableUtil.getAllColumns(this.table);
        if (allColumns != null) {
            for (int i2 = 0; i2 <= modIndex; ++i2) {
                startX += allColumns.get(i2).getWidth().intValue();
            }
        }
        List<ColumnGroupInfo> parentColumnGroups = new ColumnUtil(this.resizeColumnData.getColumnIndex()).getParentColumnGroups(this.table.getColumns());
        for (ColumnGroupInfo colGroupInfo : parentColumnGroups) {
            if (colGroupInfo.x > startX || startX > colGroupInfo.x + colGroupInfo.columnGroup.getWidth()) continue;
            this.resizeColumn(colGroupInfo.columnGroup, startX - colGroupInfo.x, deltaWidth);
        }
        this.resizeColumn(modColumn, modColumn.getWidth(), deltaWidth);
    }

    private void resizeColumn(BaseColumn column, int startX, int amount) throws CommandException {
        StandardColumn standardColumn;
        StandardBaseColumn standardBaseColumn;
        if (amount < -startX) {
            amount = -startX;
        }
        StandardBaseColumn standardBaseColumn2 = standardBaseColumn = column instanceof StandardBaseColumn ? (StandardBaseColumn)column : null;
        if (standardBaseColumn != null) {
            this.individualResizeCommandStack.execute(new SimpleResizeColumnCommand(standardBaseColumn, standardBaseColumn.getWidth() + amount));
        }
        StandardColumn standardColumn2 = standardColumn = column instanceof StandardColumn ? (StandardColumn)column : null;
        if (standardColumn != null) {
            this.resizeChildren(standardColumn.getDetailCell(), startX, amount);
        }
        this.resizeChildren(column.getTableHeader(), startX, amount);
        this.resizeChildren(column.getColumnHeader(), startX, amount);
        this.resizeChildren(column.getColumnFooter(), startX, amount);
        this.resizeChildren(column.getTableFooter(), startX, amount);
        for (GroupCell header : column.getGroupHeaders()) {
            this.resizeChildren(header.getCell(), startX, amount);
        }
        for (GroupCell footer : column.getGroupFooters()) {
            this.resizeChildren(footer.getCell(), startX, amount);
        }
    }

    private void resizeChildren(JRElementGroup elementGroup, int startX, int amount) throws CommandException {
        if (elementGroup != null && startX >= 0) {
            for (JRChild child : elementGroup.getChildren()) {
                int childStartX = startX;
                int childAmount = amount;
                if (child instanceof JRFrame) {
                    childStartX = startX - ((JRFrame)child).getX();
                }
                if (child instanceof JRBaseElement) {
                    JRBaseElement be = (JRBaseElement)child;
                    int resizeAmount = 0;
                    int moveAmount = 0;
                    if (startX <= be.getX()) {
                        resizeAmount = 0;
                        moveAmount = amount;
                    } else if (startX <= be.getX() + be.getWidth()) {
                        if (amount < be.getX() - startX) {
                            resizeAmount = be.getX() - startX;
                            moveAmount = amount - resizeAmount;
                        } else {
                            resizeAmount = amount;
                            moveAmount = amount - resizeAmount;
                        }
                    } else if (startX + amount < be.getX() + be.getWidth()) {
                        if (startX + amount > be.getX()) {
                            resizeAmount = amount + (startX - (be.getX() + be.getWidth()));
                            moveAmount = 0;
                        } else {
                            resizeAmount = -be.getWidth();
                            moveAmount = startX + amount - be.getX();
                        }
                    } else {
                        resizeAmount = 0;
                        moveAmount = 0;
                    }
                    if (resizeAmount != 0) {
                        this.individualResizeCommandStack.execute(new ResizeElementCommand(be, be.getWidth() + resizeAmount));
                    }
                    if (moveAmount != 0) {
                        moveAmount = be.getX() + moveAmount < 0 ? -be.getX() : moveAmount;
                        this.individualResizeCommandStack.execute(new MoveElementCommand(be, be.getX() + moveAmount));
                    }
                    childAmount = resizeAmount;
                }
                if (!(child instanceof JRElementGroup)) continue;
                JRElementGroup eg = (JRElementGroup)child;
                this.resizeChildren(eg, childStartX, childAmount);
            }
        }
    }

    @Override
    public void undo() {
        this.individualResizeCommandStack.undoAll();
    }

    @Override
    public void redo() {
        this.individualResizeCommandStack.redoAll();
    }

    public static class ColumnGroupInfo {
        public int x;
        public int colIndex;
        public ColumnGroup columnGroup;
    }

    public static class ColumnUtil {
        private boolean found = false;
        private int colIndex;
        private int crtColIndex;
        private int crtColX;
        private List<ColumnGroupInfo> parentColumnGroups = new ArrayList<ColumnGroupInfo>();

        ColumnUtil(int colIndex) {
            this.colIndex = colIndex;
        }

        public List<ColumnGroupInfo> getParentColumnGroups(List<BaseColumn> columns) {
            Iterator<BaseColumn> it = columns.iterator();
            while (!this.found && it.hasNext()) {
                BaseColumn column = it.next();
                if (column instanceof ColumnGroup) {
                    ColumnGroupInfo colGroupInfo = new ColumnGroupInfo();
                    colGroupInfo.x = this.crtColX;
                    colGroupInfo.colIndex = this.crtColIndex;
                    colGroupInfo.columnGroup = (ColumnGroup)column;
                    this.parentColumnGroups.add(colGroupInfo);
                    this.getParentColumnGroups(((ColumnGroup)column).getColumns());
                    if (this.found) continue;
                    this.parentColumnGroups.remove(this.parentColumnGroups.size() - 1);
                    continue;
                }
                if (this.colIndex == this.crtColIndex) {
                    this.found = true;
                    return this.parentColumnGroups;
                }
                ++this.crtColIndex;
                this.crtColX += column.getWidth().intValue();
            }
            return this.parentColumnGroups;
        }
    }
}

