/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.headertoolbar.actions.AbstractVerifiableTableAction;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnValueData;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnValuesCommand;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class EditColumnValuesAction
extends AbstractVerifiableTableAction {
    public void setEditColumnValueData(EditColumnValueData editColumnValueData) {
        this.columnData = editColumnValueData;
    }

    public EditColumnValueData getEditColumnValueData() {
        return (EditColumnValueData)this.columnData;
    }

    public String getName() {
        return "edit_column_value_action";
    }

    @Override
    public void performAction() throws ActionException {
        try {
            this.getCommandStack().execute(new ResetInCacheCommand(new EditColumnValuesCommand(this.table, this.getEditColumnValueData()), this.getJasperReportsContext(), this.getReportContext(), this.targetUri));
        }
        catch (CommandException e2) {
            throw new ActionException(e2.getMessage());
        }
    }

    @Override
    public void verify() throws ActionException {
        List<BaseColumn> allCols;
        StandardColumn col;
        JRTextField textField;
        EditColumnValueData colValData = this.getEditColumnValueData();
        if (colValData.getFontSize() != null) {
            try {
                Integer.valueOf(colValData.getFontSize());
            }
            catch (NumberFormatException e2) {
                this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.values.invalid.font.size", colValData.getFontSize());
            }
        }
        if (TableUtil.hasSingleChunkExpression(textField = TableUtil.getColumnDetailTextElement(col = (StandardColumn)(allCols = TableUtil.getAllColumns(this.table)).get(colValData.getColumnIndex())))) {
            JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.table.getDatasetRun();
            String datasetName = datasetRun.getDatasetName();
            JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
            JasperDesign jasperDesign = cache.getJasperDesign(this.targetUri);
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
            String textFieldName = textField.getExpression().getChunks()[0].getText();
            FilterTypesEnum filterType = null;
            for (JRField field : dataset.getFields()) {
                if (!textFieldName.equals(field.getName())) continue;
                filterType = HeaderToolbarElementUtils.getFilterType(field.getValueClass());
                break;
            }
            if (filterType != null) {
                Locale locale = (Locale)this.getReportContext().getParameterValue("REPORT_LOCALE");
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                if (filterType.equals(FilterTypesEnum.DATE)) {
                    try {
                        formatFactory.createDateFormat(colValData.getFormatPattern(), locale, null);
                    }
                    catch (IllegalArgumentException e3) {
                        this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.column.values.invalid.date.pattern", colValData.getFormatPattern());
                    }
                } else if (filterType.equals(FilterTypesEnum.NUMERIC)) {
                    try {
                        formatFactory.createNumberFormat(colValData.getFormatPattern(), locale);
                    }
                    catch (IllegalArgumentException e4) {
                        this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.column.values.invalid.number.pattern", colValData.getFormatPattern());
                    }
                }
            }
        }
    }
}

