/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartRenderableFactory;
import net.sf.jasperreports.charts.util.ChartRendererFactory;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.fill.DefaultChartTheme;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.data.Range;

public final class ChartUtil {
    private static final JRSingletonCache<ChartRendererFactory> CHART_RENDERER_FACTORY_CACHE = new JRSingletonCache<ChartRendererFactory>(ChartRendererFactory.class);
    protected static final double AUTO_TICK_UNIT_THRESHOLD = 1.0E12;
    protected static final double AUTO_TICK_UNIT_FACTOR = 1000.0;
    private JasperReportsContext jasperReportsContext;

    private ChartUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static ChartUtil getDefaultInstance() {
        return new ChartUtil(DefaultJasperReportsContext.getInstance());
    }

    public static ChartUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new ChartUtil(jasperReportsContext);
    }

    public static List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Graphics2D grx, Rectangle2D renderingArea) {
        ArrayList<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            if (grx == null) {
                chart.createBufferedImage((int)renderingArea.getWidth(), (int)renderingArea.getHeight(), renderingInfo);
            } else {
                chart.draw(grx, renderingArea, renderingInfo);
            }
            EntityCollection entityCollection = renderingInfo.getEntityCollection();
            if (entityCollection != null && entityCollection.getEntityCount() > 0) {
                areaHyperlinks = new ArrayList<JRPrintImageAreaHyperlink>(entityCollection.getEntityCount());
                for (ChartEntity entity : entityCollection) {
                    JRPrintHyperlink printHyperlink = chartHyperlinkProvider.getEntityHyperlink(entity);
                    if (printHyperlink == null) continue;
                    JRPrintImageArea area = ChartUtil.getImageArea(entity);
                    JRPrintImageAreaHyperlink areaHyperlink = new JRPrintImageAreaHyperlink();
                    areaHyperlink.setArea(area);
                    areaHyperlink.setHyperlink(printHyperlink);
                    areaHyperlinks.add(areaHyperlink);
                }
            }
        }
        return areaHyperlinks;
    }

    private static JRPrintImageArea getImageArea(ChartEntity entity) {
        JRPrintImageArea area = new JRPrintImageArea();
        area.setShape(JRPrintImageArea.getShape(entity.getShapeType()));
        int[] coordinates = ChartUtil.getCoordinates(entity);
        if (coordinates != null) {
            area.setCoordinates(coordinates);
        }
        return area;
    }

    private static int[] getCoordinates(ChartEntity entity) {
        int[] coordinates = null;
        String shapeCoords = entity.getShapeCoords();
        if (shapeCoords != null && shapeCoords.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(shapeCoords, ",");
            coordinates = new int[tokens.countTokens()];
            int idx = 0;
            while (tokens.hasMoreTokens()) {
                String coord = tokens.nextToken();
                coordinates[idx] = Integer.parseInt(coord);
                ++idx;
            }
        }
        return coordinates;
    }

    public ChartTheme getTheme(String themeName) {
        if (themeName == null) {
            return new DefaultChartTheme();
        }
        List<ChartThemeBundle> themeBundles = this.jasperReportsContext.getExtensions(ChartThemeBundle.class);
        for (ChartThemeBundle bundle : themeBundles) {
            ChartTheme chartTheme = bundle.getChartTheme(themeName);
            if (chartTheme == null) continue;
            return chartTheme;
        }
        throw new JRRuntimeException("Chart theme '" + themeName + "' not found.");
    }

    public static ChartTheme getChartTheme(String themeName) {
        return ChartUtil.getDefaultInstance().getTheme(themeName);
    }

    public ChartRenderableFactory getChartRenderableFactory(String renderType) {
        String factoryClass = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty("net.sf.jasperreports.chart.renderer.factory." + renderType);
        if (factoryClass == null) {
            throw new JRRuntimeException("No chart renderer factory specifyed for '" + renderType + "' render type.");
        }
        try {
            ChartRendererFactory factory = CHART_RENDERER_FACTORY_CACHE.getCachedInstance(factoryClass);
            if (factory instanceof ChartRenderableFactory) {
                return (ChartRenderableFactory)factory;
            }
            return new WrappingChartRenderableFactory(factory);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    public static ChartRendererFactory getChartRendererFactory(String renderType) {
        return ChartUtil.getDefaultInstance().getChartRenderableFactory(renderType);
    }

    public TickUnitSource createIntegerTickUnits() {
        TickUnits units = (TickUnits)NumberAxis.createIntegerTickUnits();
        DecimalFormat format = new DecimalFormat("#,##0");
        units.add((TickUnit)new NumberTickUnit(2.0E10, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E10, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E11, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E11, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E11, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E12, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E12, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E12, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E13, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E13, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E13, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E14, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E14, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E14, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E15, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E15, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E15, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E16, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E16, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E16, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E17, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E17, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E17, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E18, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.0E18, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E18, (NumberFormat)format));
        return units;
    }

    public TickUnitSource createStandardTickUnits() {
        TickUnits units = (TickUnits)NumberAxis.createStandardTickUnits();
        DecimalFormat format = new DecimalFormat("#,##0");
        units.add((TickUnit)new NumberTickUnit(1.0E12, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E12, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E12, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E13, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E13, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E13, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E14, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E14, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E14, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E15, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E15, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E15, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E16, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E16, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E16, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E17, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E17, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E17, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(1.0E18, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(2.5E18, (NumberFormat)format));
        units.add((TickUnit)new NumberTickUnit(5.0E18, (NumberFormat)format));
        return units;
    }

    public void setAutoTickUnit(NumberAxis numberAxis) {
        Range range;
        if (numberAxis.isAutoTickUnitSelection() && (range = numberAxis.getRange()).getLength() >= 1.0E12) {
            double autoSize = range.getLength() / 1.0E12;
            TickUnit unit = numberAxis.getStandardTickUnits().getCeilingTickUnit(autoSize);
            numberAxis.setTickUnit((NumberTickUnit)unit, false, false);
        }
    }

    public static class WrappingChartRenderableFactory
    implements ChartRenderableFactory {
        private ChartRendererFactory factory;

        public WrappingChartRenderableFactory(ChartRendererFactory factory) {
            this.factory = factory;
        }

        @Override
        public JRRenderable getRenderer(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
            return this.factory.getRenderer(chart, chartHyperlinkProvider, rectangle);
        }

        @Override
        public Renderable getRenderable(JasperReportsContext jasperReportsContext, JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Rectangle2D rectangle) {
            JRRenderable deprecatedRenderer = this.getRenderer(chart, chartHyperlinkProvider, rectangle);
            return RenderableUtil.getWrappingRenderable(deprecatedRenderer);
        }
    }
}

