/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;

public abstract class Certificate {
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((Certificate)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] != byArray2[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public int hashCode() {
        int n2 = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n3 = 1;
            while (n3 < byArray.length) {
                n2 += byArray[n3] * n3;
                ++n3;
            }
            return n2;
        }
        catch (CertificateException certificateException) {
            return n2;
        }
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;
}

