/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.RenderFilter;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;

public class FilteredRenderListener
implements RenderListener {
    private final RenderListener delegate;
    private final RenderFilter[] filters;

    public FilteredRenderListener(RenderListener delegate, RenderFilter ... filters) {
        this.delegate = delegate;
        this.filters = filters;
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        RenderFilter[] renderFilterArray = this.filters;
        int n2 = this.filters.length;
        int n3 = 0;
        while (n3 < n2) {
            RenderFilter filter = renderFilterArray[n3];
            if (!filter.allowText(renderInfo)) {
                return;
            }
            ++n3;
        }
        this.delegate.renderText(renderInfo);
    }

    @Override
    public void beginTextBlock() {
        this.delegate.beginTextBlock();
    }

    @Override
    public void endTextBlock() {
        this.delegate.endTextBlock();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        RenderFilter[] renderFilterArray = this.filters;
        int n2 = this.filters.length;
        int n3 = 0;
        while (n3 < n2) {
            RenderFilter filter = renderFilterArray[n3];
            if (!filter.allowImage(renderInfo)) {
                return;
            }
            ++n3;
        }
        this.delegate.renderImage(renderInfo);
    }
}

