/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.GlyphList;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PageResources;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.Type3Glyph;
import java.io.IOException;
import java.util.HashMap;

public class Type3Font
extends BaseFont {
    private boolean[] usedSlot;
    private IntHashtable widths3 = new IntHashtable();
    private HashMap<Integer, Type3Glyph> char2glyph = new HashMap();
    private PdfWriter writer;
    private float llx = Float.NaN;
    private float lly;
    private float urx;
    private float ury;
    private PageResources pageResources = new PageResources();
    private boolean colorized;

    public Type3Font(PdfWriter writer, char[] chars, boolean colorized) {
        this(writer, colorized);
    }

    public Type3Font(PdfWriter writer, boolean colorized) {
        this.writer = writer;
        this.colorized = colorized;
        this.fontType = 5;
        this.usedSlot = new boolean[256];
    }

    public PdfContentByte defineGlyph(char c2, float wx, float llx, float lly, float urx, float ury) {
        if (c2 == '\u0000' || c2 > '\u00ff') {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.char.1.doesn.t.belong.in.this.type3.font", c2));
        }
        this.usedSlot[c2] = true;
        Integer ck = new Integer(c2);
        Type3Glyph glyph = this.char2glyph.get(ck);
        if (glyph != null) {
            return glyph;
        }
        this.widths3.put(c2, (int)wx);
        if (!this.colorized) {
            if (Float.isNaN(this.llx)) {
                this.llx = llx;
                this.lly = lly;
                this.urx = urx;
                this.ury = ury;
            } else {
                this.llx = Math.min(this.llx, llx);
                this.lly = Math.min(this.lly, lly);
                this.urx = Math.max(this.urx, urx);
                this.ury = Math.max(this.ury, ury);
            }
        }
        glyph = new Type3Glyph(this.writer, this.pageResources, wx, llx, lly, urx, ury, this.colorized);
        this.char2glyph.put(ck, glyph);
        return glyph;
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        return 0.0f;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", ""}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", ""}};
    }

    @Override
    public int getKerning(int char1, int char2) {
        return 0;
    }

    @Override
    public String getPostscriptFontName() {
        return "";
    }

    @Override
    protected int[] getRawCharBBox(int c2, String name) {
        return null;
    }

    @Override
    int getRawWidth(int c2, String name) {
        return 0;
    }

    @Override
    public boolean hasKernPairs() {
        return false;
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        return false;
    }

    @Override
    public void setPostscriptFontName(String name) {
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        if (this.writer != writer) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("type3.font.used.with.the.wrong.pdfwriter"));
        }
        int firstChar = 0;
        while (firstChar < this.usedSlot.length && !this.usedSlot[firstChar]) {
            ++firstChar;
        }
        if (firstChar == this.usedSlot.length) {
            throw new DocumentException(MessageLocalization.getComposedMessage("no.glyphs.defined.for.type3.font"));
        }
        int lastChar = this.usedSlot.length - 1;
        while (lastChar >= firstChar && !this.usedSlot[lastChar]) {
            --lastChar;
        }
        int[] widths = new int[lastChar - firstChar + 1];
        int[] invOrd = new int[lastChar - firstChar + 1];
        int invOrdIndx = 0;
        int w2 = 0;
        int u2 = firstChar;
        while (u2 <= lastChar) {
            if (this.usedSlot[u2]) {
                invOrd[invOrdIndx++] = u2;
                widths[w2] = this.widths3.get(u2);
            }
            ++u2;
            ++w2;
        }
        PdfArray diffs = new PdfArray();
        PdfDictionary charprocs = new PdfDictionary();
        int last = -1;
        int k2 = 0;
        while (k2 < invOrdIndx) {
            int c2 = invOrd[k2];
            if (c2 > last) {
                last = c2;
                diffs.add(new PdfNumber(last));
            }
            ++last;
            int c22 = invOrd[k2];
            String s2 = GlyphList.unicodeToName(c22);
            if (s2 == null) {
                s2 = "a" + c22;
            }
            PdfName n2 = new PdfName(s2);
            diffs.add(n2);
            Type3Glyph glyph = this.char2glyph.get(new Integer(c22));
            PdfStream stream = new PdfStream(glyph.toPdf(null));
            stream.flateCompress(this.compressionLevel);
            PdfIndirectReference refp = writer.addToBody(stream).getIndirectReference();
            charprocs.put(n2, refp);
            ++k2;
        }
        PdfDictionary font = new PdfDictionary(PdfName.FONT);
        font.put(PdfName.SUBTYPE, PdfName.TYPE3);
        if (this.colorized) {
            font.put(PdfName.FONTBBOX, new PdfRectangle(0.0f, 0.0f, 0.0f, 0.0f));
        } else {
            font.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        }
        font.put(PdfName.FONTMATRIX, new PdfArray(new float[]{0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f}));
        font.put(PdfName.CHARPROCS, writer.addToBody(charprocs).getIndirectReference());
        PdfDictionary encoding = new PdfDictionary();
        encoding.put(PdfName.DIFFERENCES, diffs);
        font.put(PdfName.ENCODING, writer.addToBody(encoding).getIndirectReference());
        font.put(PdfName.FIRSTCHAR, new PdfNumber(firstChar));
        font.put(PdfName.LASTCHAR, new PdfNumber(lastChar));
        font.put(PdfName.WIDTHS, writer.addToBody(new PdfArray(widths)).getIndirectReference());
        if (this.pageResources.hasResources()) {
            font.put(PdfName.RESOURCES, writer.addToBody(this.pageResources.getResources()).getIndirectReference());
        }
        writer.addToBody((PdfObject)font, ref);
    }

    @Override
    public PdfStream getFullFontStream() {
        return null;
    }

    @Override
    byte[] convertToBytes(String text) {
        char[] cc = text.toCharArray();
        byte[] b2 = new byte[cc.length];
        int p2 = 0;
        int k2 = 0;
        while (k2 < cc.length) {
            char c2 = cc[k2];
            if (this.charExists(c2)) {
                b2[p2++] = (byte)c2;
            }
            ++k2;
        }
        if (b2.length == p2) {
            return b2;
        }
        byte[] b22 = new byte[p2];
        System.arraycopy(b2, 0, b22, 0, p2);
        return b22;
    }

    @Override
    byte[] convertToBytes(int char1) {
        if (this.charExists(char1)) {
            return new byte[]{(byte)char1};
        }
        return new byte[0];
    }

    @Override
    public int getWidth(int char1) {
        if (!this.widths3.containsKey(char1)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.char.1.is.not.defined.in.a.type3.font", char1));
        }
        return this.widths3.get(char1);
    }

    @Override
    public int getWidth(String text) {
        char[] c2 = text.toCharArray();
        int total = 0;
        int k2 = 0;
        while (k2 < c2.length) {
            total += this.getWidth(c2[k2]);
            ++k2;
        }
        return total;
    }

    @Override
    public int[] getCharBBox(int c2) {
        return null;
    }

    @Override
    public boolean charExists(int c2) {
        if (c2 > 0 && c2 < 256) {
            return this.usedSlot[c2];
        }
        return false;
    }

    @Override
    public boolean setCharAdvance(int c2, int advance) {
        return false;
    }
}

