/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.FdfReader;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FdfWriter {
    private static final byte[] HEADER_FDF = DocWriter.getISOBytes("%FDF-1.2\n%\u00e2\u00e3\u00cf\u00d3\n");
    HashMap<String, Object> fields = new HashMap();
    private String file;

    public void writeTo(OutputStream os) throws IOException {
        Wrt wrt = new Wrt(os, this);
        wrt.writeTo();
    }

    boolean setField(String field, PdfObject value) {
        HashMap obj;
        String s2;
        HashMap<String, Object> map;
        block4: {
            map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            while (true) {
                s2 = tk.nextToken();
                obj = map.get(s2);
                if (!tk.hasMoreTokens()) break block4;
                if (obj == null) {
                    obj = new HashMap();
                    map.put(s2, obj);
                    map = obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = obj;
            }
            return false;
        }
        if (!(obj instanceof HashMap)) {
            map.put(s2, value);
            return true;
        }
        return false;
    }

    void iterateFields(HashMap<String, Object> values, HashMap<String, Object> map, String name) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String s2 = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof HashMap) {
                this.iterateFields(values, (HashMap)obj, String.valueOf(name) + "." + s2);
                continue;
            }
            values.put((String.valueOf(name) + "." + s2).substring(1), obj);
        }
    }

    public boolean removeField(String field) {
        Object obj;
        ArrayList<Object> hist;
        HashMap map;
        block5: {
            map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            hist = new ArrayList<Object>();
            while (true) {
                String s2;
                if ((obj = map.get(s2 = tk.nextToken())) == null) {
                    return false;
                }
                hist.add(map);
                hist.add(s2);
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return false;
        }
        if (obj instanceof HashMap) {
            return false;
        }
        int k2 = hist.size() - 2;
        while (k2 >= 0) {
            map = (HashMap)hist.get(k2);
            String s3 = (String)hist.get(k2 + 1);
            map.remove(s3);
            if (!map.isEmpty()) break;
            k2 -= 2;
        }
        return true;
    }

    public HashMap<String, Object> getFields() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.iterateFields(values, this.fields, "");
        return values;
    }

    public String getField(String field) {
        Object obj;
        block5: {
            HashMap map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return null;
            }
            while (true) {
                String s2;
                if ((obj = map.get(s2 = tk.nextToken())) == null) {
                    return null;
                }
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return null;
        }
        if (obj instanceof HashMap) {
            return null;
        }
        if (((PdfObject)obj).isString()) {
            return ((PdfString)obj).toUnicodeString();
        }
        return PdfName.decodeName(obj.toString());
    }

    public boolean setFieldAsName(String field, String value) {
        return this.setField(field, new PdfName(value));
    }

    public boolean setFieldAsString(String field, String value) {
        return this.setField(field, new PdfString(value, "UnicodeBig"));
    }

    public boolean setFieldAsAction(String field, PdfAction action) {
        return this.setField(field, action);
    }

    public void setFields(FdfReader fdf) {
        HashMap<String, PdfDictionary> map = fdf.getFields();
        for (Map.Entry<String, PdfDictionary> entry : map.entrySet()) {
            String key = entry.getKey();
            PdfDictionary dic = entry.getValue();
            PdfObject v2 = dic.get(PdfName.V);
            if (v2 != null) {
                this.setField(key, v2);
            }
            if ((v2 = dic.get(PdfName.A)) == null) continue;
            this.setField(key, v2);
        }
    }

    public void setFields(PdfReader pdf) {
        this.setFields(pdf.getAcroFields());
    }

    public void setFields(AcroFields af) {
        for (Map.Entry<String, AcroFields.Item> entry : af.getFields().entrySet()) {
            PdfObject ft;
            String fn = entry.getKey();
            AcroFields.Item item = entry.getValue();
            PdfDictionary dic = item.getMerged(0);
            PdfObject v2 = PdfReader.getPdfObjectRelease(dic.get(PdfName.V));
            if (v2 == null || (ft = PdfReader.getPdfObjectRelease(dic.get(PdfName.FT))) == null || PdfName.SIG.equals(ft)) continue;
            this.setField(fn, v2);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    static class Wrt
    extends PdfWriter {
        private FdfWriter fdf;

        Wrt(OutputStream os, FdfWriter fdf) throws IOException {
            super(new PdfDocument(), os);
            this.fdf = fdf;
            this.os.write(HEADER_FDF);
            this.body = new PdfWriter.PdfBody(this);
        }

        void writeTo() throws IOException {
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.FIELDS, this.calculate(this.fdf.fields));
            if (this.fdf.file != null) {
                dic.put(PdfName.F, new PdfString(this.fdf.file, "UnicodeBig"));
            }
            PdfDictionary fd = new PdfDictionary();
            fd.put(PdfName.FDF, dic);
            PdfIndirectReference ref = this.addToBody(fd).getIndirectReference();
            this.os.write(Wrt.getISOBytes("trailer\n"));
            PdfDictionary trailer = new PdfDictionary();
            trailer.put(PdfName.ROOT, ref);
            trailer.toPdf(null, this.os);
            this.os.write(Wrt.getISOBytes("\n%%EOF\n"));
            this.os.close();
        }

        PdfArray calculate(HashMap<String, Object> map) throws IOException {
            PdfArray ar = new PdfArray();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object v2 = entry.getValue();
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.T, new PdfString(key, "UnicodeBig"));
                if (v2 instanceof HashMap) {
                    dic.put(PdfName.KIDS, this.calculate((HashMap)v2));
                } else if (v2 instanceof PdfAction) {
                    dic.put(PdfName.A, (PdfAction)v2);
                } else {
                    dic.put(PdfName.V, (PdfObject)v2);
                }
                ar.add(dic);
            }
            return ar;
        }
    }
}

