/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.fonts.cmaps.CMap;
import com.itextpdf.text.pdf.fonts.cmaps.CMapParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary fontDic;
    private int spaceWidth;
    private CMap toUnicodeCmap;
    private char[] cidbyte2uni;

    public CMapAwareDocumentFont(PRIndirectReference refFont) {
        super(refFont);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(refFont);
        this.processToUnicode();
        if (this.toUnicodeCmap == null) {
            this.processUni2Byte();
        }
        this.spaceWidth = super.getWidth(32);
        if (this.spaceWidth == 0) {
            this.spaceWidth = this.computeAverageWidth();
        }
    }

    private void processToUnicode() {
        PdfObject toUni = this.fontDic.get(PdfName.TOUNICODE);
        if (toUni != null) {
            try {
                byte[] touni = PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObjectRelease(toUni));
                CMapParser cmapParser = new CMapParser();
                this.toUnicodeCmap = cmapParser.parse(new ByteArrayInputStream(touni));
            }
            catch (IOException e2) {
                throw new Error("Unable to process ToUnicode map - " + e2.getMessage(), e2);
            }
        }
    }

    private void processUni2Byte() {
        IntHashtable uni2byte = this.getUni2Byte();
        int[] e2 = uni2byte.toOrderedKeys();
        this.cidbyte2uni = new char[256];
        int k2 = 0;
        while (k2 < e2.length) {
            int n2 = uni2byte.get(e2[k2]);
            if (this.cidbyte2uni[n2] == '\u0000') {
                this.cidbyte2uni[n2] = (char)e2[k2];
            }
            ++k2;
        }
    }

    private int computeAverageWidth() {
        int count = 0;
        int total = 0;
        int i2 = 0;
        while (i2 < this.widths.length) {
            if (this.widths[i2] != 0) {
                total += this.widths[i2];
                ++count;
            }
            ++i2;
        }
        return count != 0 ? total / count : 0;
    }

    @Override
    public int getWidth(int char1) {
        if (char1 == 32) {
            return this.spaceWidth;
        }
        return super.getWidth(char1);
    }

    private String decodeSingleCID(byte[] bytes, int offset, int len) {
        if (this.toUnicodeCmap != null) {
            if (offset + len > bytes.length) {
                throw new ArrayIndexOutOfBoundsException(MessageLocalization.getComposedMessage("invalid.index.1", offset + len));
            }
            return this.toUnicodeCmap.lookup(bytes, offset, len);
        }
        if (len == 1) {
            return new String(this.cidbyte2uni, 0xFF & bytes[offset], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public String decode(byte[] cidbytes, int offset, int len) {
        StringBuffer sb = new StringBuffer();
        int i2 = offset;
        while (i2 < offset + len) {
            String rslt = this.decodeSingleCID(cidbytes, i2, 1);
            if (rslt == null) {
                rslt = this.decodeSingleCID(cidbytes, i2, 2);
                ++i2;
            }
            sb.append(rslt);
            ++i2;
        }
        return sb.toString();
    }

    public String encode(byte[] bytes, int offset, int len) {
        return this.decode(bytes, offset, len);
    }
}

