/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IncTable
implements Element {
    private HashMap<String, String> props = new HashMap();
    private ArrayList<ArrayList<PdfPCell>> rows = new ArrayList();
    private ArrayList<PdfPCell> cols;

    public IncTable(HashMap<String, String> props) {
        this.props.putAll(props);
    }

    public void addCol(PdfPCell cell) {
        if (this.cols == null) {
            this.cols = new ArrayList();
        }
        this.cols.add(cell);
    }

    public void addCols(ArrayList<PdfPCell> ncols) {
        if (this.cols == null) {
            this.cols = new ArrayList<PdfPCell>(ncols);
        } else {
            this.cols.addAll(ncols);
        }
    }

    public void endRow() {
        if (this.cols != null) {
            Collections.reverse(this.cols);
            this.rows.add(this.cols);
            this.cols = null;
        }
    }

    public ArrayList<ArrayList<PdfPCell>> getRows() {
        return this.rows;
    }

    public PdfPTable buildTable() {
        if (this.rows.isEmpty()) {
            return new PdfPTable(1);
        }
        int ncol = 0;
        for (PdfPCell pc : this.rows.get(0)) {
            ncol += pc.getColspan();
        }
        PdfPTable table = new PdfPTable(ncol);
        String width = this.props.get("width");
        if (width == null) {
            table.setWidthPercentage(100.0f);
        } else if (width.endsWith("%")) {
            table.setWidthPercentage(Float.parseFloat(width.substring(0, width.length() - 1)));
        } else {
            table.setTotalWidth(Float.parseFloat(width));
            table.setLockedWidth(true);
        }
        for (ArrayList<PdfPCell> col : this.rows) {
            for (PdfPCell pc : col) {
                table.addCell(pc);
            }
        }
        return table;
    }

    @Override
    public ArrayList<Chunk> getChunks() {
        return null;
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    @Override
    public boolean process(ElementListener listener) {
        return false;
    }

    @Override
    public int type() {
        return 0;
    }
}

