/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import java.util.ArrayList;
import java.util.HashMap;

public class ChainedProperties {
    public static final int[] fontSizes = new int[]{8, 10, 12, 14, 18, 24, 36};
    public ArrayList<ChainedProperty> chain = new ArrayList();

    public String getProperty(String key) {
        int k2 = this.chain.size() - 1;
        while (k2 >= 0) {
            ChainedProperty p2 = this.chain.get(k2);
            HashMap<String, String> prop = p2.property;
            String ret = prop.get(key);
            if (ret != null) {
                return ret;
            }
            --k2;
        }
        return null;
    }

    public boolean hasProperty(String key) {
        int k2 = this.chain.size() - 1;
        while (k2 >= 0) {
            ChainedProperty p2 = this.chain.get(k2);
            HashMap<String, String> prop = p2.property;
            if (prop.containsKey(key)) {
                return true;
            }
            --k2;
        }
        return false;
    }

    public void addToChain(String key, HashMap<String, String> prop) {
        String value = prop.get("size");
        if (value != null) {
            if (value.endsWith("pt")) {
                prop.put("size", value.substring(0, value.length() - 2));
            } else {
                int s2 = 0;
                if (value.startsWith("+") || value.startsWith("-")) {
                    String old = this.getProperty("basefontsize");
                    if (old == null) {
                        old = "12";
                    }
                    float f2 = Float.parseFloat(old);
                    int c2 = (int)f2;
                    int k2 = fontSizes.length - 1;
                    while (k2 >= 0) {
                        if (c2 >= fontSizes[k2]) {
                            s2 = k2;
                            break;
                        }
                        --k2;
                    }
                    int inc = Integer.parseInt(value.startsWith("+") ? value.substring(1) : value);
                    s2 += inc;
                } else {
                    try {
                        s2 = Integer.parseInt(value) - 1;
                    }
                    catch (NumberFormatException nfe) {
                        s2 = 0;
                    }
                }
                if (s2 < 0) {
                    s2 = 0;
                } else if (s2 >= fontSizes.length) {
                    s2 = fontSizes.length - 1;
                }
                prop.put("size", Integer.toString(fontSizes[s2]));
            }
        }
        this.chain.add(new ChainedProperty(key, prop));
    }

    public void removeChain(String key) {
        int k2 = this.chain.size() - 1;
        while (k2 >= 0) {
            if (key.equals(this.chain.get((int)k2).key)) {
                this.chain.remove(k2);
                return;
            }
            --k2;
        }
    }

    private static final class ChainedProperty {
        final String key;
        final HashMap<String, String> property;

        ChainedProperty(String key, HashMap<String, String> property) {
            this.key = key;
            this.property = property;
        }
    }
}

