/*
 * Decompiled with CFR 0.152.
 */
package bsh.org.objectweb.asm;

final class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n2) {
        this.data = new byte[n2];
    }

    public ByteVector put1(int n2) {
        int n3 = this.length;
        if (n3 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector put11(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector put2(int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector put12(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)(n3 >>> 8);
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector put4(int n2) {
        int n3 = this.length;
        if (n3 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector put8(long l2) {
        int n2 = this.length;
        if (n2 + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] byArray = this.data;
        int n3 = (int)(l2 >>> 32);
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        n3 = (int)l2;
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        this.length = n2;
        return this;
    }

    public ByteVector putUTF(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n2 = string.charAt(n5);
            n4 = n2 >= 1 && n2 <= 127 ? ++n4 : (n2 > 2047 ? (n4 += 3) : (n4 += 2));
            ++n5;
        }
        if (n4 > 65535) {
            throw new IllegalArgumentException();
        }
        n2 = this.length;
        if (n2 + 2 + n4 > this.data.length) {
            this.enlarge(2 + n4);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n4 >>> 8);
        byArray[n2++] = (byte)n4;
        int n6 = 0;
        while (n6 < n3) {
            char c2 = string.charAt(n6);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n2++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                byArray[n2++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c2 & 0x3F);
            } else {
                byArray[n2++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                byArray[n2++] = (byte)(0x80 | c2 & 0x3F);
            }
            ++n6;
        }
        this.length = n2;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n2, int n3) {
        if (this.length + n3 > this.data.length) {
            this.enlarge(n3);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n2, this.data, this.length, n3);
        }
        this.length += n3;
        return this;
    }

    private void enlarge(int n2) {
        byte[] byArray = new byte[Math.max(2 * this.data.length, this.length + n2)];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        this.data = byArray;
    }
}

