/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import util.GUIUtils;

public class PDFSignerUtil {
    static String evalFileName = "ePDFSigner.key";

    public static int getDaysBetween(Date keyDate) {
        Date currentDate = new Date();
        Calendar d1 = Calendar.getInstance();
        d1.set(keyDate.getYear(), keyDate.getMonth(), keyDate.getDate());
        d1.add(5, 45);
        Calendar d2 = Calendar.getInstance();
        d2.set(currentDate.getYear(), currentDate.getMonth(), currentDate.getDate());
        if (d1.after(d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            d1 = (Calendar)d1.clone();
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    public static void deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].isDirectory()) {
                    PDFSignerUtil.deleteDirectory(files[i2]);
                } else {
                    files[i2].delete();
                }
                ++i2;
            }
        }
    }

    public static void createKeyFile(String filePath) {
        File keyFile = new File(filePath);
        File file = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] keyBytes = null;
        String evaluationFilePath = String.valueOf(System.getProperty("user.dir")) + "\\lic\\ePDFSigner.key";
        try {
            fis = new FileInputStream(keyFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            keyBytes = new byte[fis.available()];
            fis.read(keyBytes);
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (new File(evaluationFilePath).exists()) {
            try {
                fos = new FileOutputStream(evaluationFilePath);
                fos.write(keyBytes);
                fos.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        } else {
            file = new File(String.valueOf(System.getProperty("user.dir")) + "\\lic");
            if (file.exists()) {
                try {
                    file = new File(file + "\\" + evalFileName);
                    fos = new FileOutputStream(file);
                    fos.write(keyBytes);
                    fos.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
            } else {
                boolean newDir = new File(String.valueOf(System.getProperty("user.dir")) + "\\lic").mkdir();
                if (newDir) {
                    try {
                        file = new File(new File(String.valueOf(System.getProperty("user.dir")) + "\\lic") + "\\" + evalFileName);
                        fos = new FileOutputStream(file);
                        fos.write(keyBytes);
                        fos.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static File copyKeyFile() {
        BufferedWriter output = null;
        File file = new File(String.valueOf(System.getProperty("user.dir")) + "\\ePDFSignerProperties");
        InputStream is = GUIUtils.class.getClassLoader().getResourceAsStream("work/howto.key");
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file.exists()) {
            try {
                file = new File(file + "\\" + "howto.key");
                output = new BufferedWriter(new FileWriter(file));
                output.write(sb.toString());
                ((Writer)output).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        } else {
            boolean newDir = new File(String.valueOf(System.getProperty("user.dir")) + "\\ePDFSignerProperties").mkdir();
            if (newDir) {
                try {
                    file = new File(new File(String.valueOf(System.getProperty("user.dir")) + "\\ePDFSignerProperties") + "\\howto.key");
                    output = new BufferedWriter(new FileWriter(file));
                    output.write(sb.toString());
                    ((Writer)output).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return file;
    }

    public static Map readCSVFile(File importTargetDirectory, DataInputStream myInput) {
        HashMap excelDataMap = new HashMap();
        ArrayList<String> pdfEmailList = new ArrayList<String>();
        ArrayList<String> pdfPasswordList = new ArrayList<String>();
        try {
            String thisLine;
            while ((thisLine = myInput.readLine()) != null) {
                StringBuilder sbEmail = new StringBuilder();
                StringBuilder sbPassword = new StringBuilder();
                String[] strar = thisLine.split(",");
                int j2 = 0;
                while (j2 < strar.length) {
                    switch (j2) {
                        case 0: {
                            sbEmail.append(strar[j2].trim());
                            sbPassword.append(strar[j2].trim());
                            break;
                        }
                        case 1: {
                            sbPassword.append(",");
                            sbPassword.append(strar[j2].trim());
                            break;
                        }
                        case 2: {
                            sbEmail.append(",");
                            sbEmail.append(strar[j2].trim());
                        }
                    }
                    ++j2;
                }
                pdfEmailList.add(sbEmail.toString());
                pdfPasswordList.add(sbPassword.toString());
            }
            excelDataMap.put("pdfEmail", pdfEmailList);
            excelDataMap.put("pdfPassword", pdfPasswordList);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return excelDataMap;
    }
}

