/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.SignerWithRecovery;
import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        if (bl) {
            this.trailer = 188;
        } else if (digest instanceof SHA1Digest) {
            this.trailer = 13260;
        } else if (digest instanceof RIPEMD160Digest) {
            this.trailer = 12748;
        } else if (digest instanceof RIPEMD128Digest) {
            this.trailer = 13004;
        } else {
            throw new IllegalArgumentException("no valid trailer for digest");
        }
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        this.cipher.init(bl, rSAKeyParameters);
        this.keyBits = rSAKeyParameters.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.mBuf = this.trailer == 188 ? new byte[this.block.length - this.digest.getDigestSize() - 2] : new byte[this.block.length - this.digest.getDigestSize() - 3];
        this.reset();
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (this.messageLength > this.mBuf.length) {
            if (this.mBuf.length > byArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 != this.mBuf.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        } else {
            if (this.messageLength != byArray2.length) {
                return false;
            }
            for (int i3 = 0; i3 != byArray2.length; ++i3) {
                if (byArray[i3] == byArray2[i3]) continue;
                return false;
            }
        }
        return true;
    }

    private void clearBlock(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    public void update(byte by) {
        this.digest.update(by);
        if (this.messageLength < this.mBuf.length) {
            this.mBuf[this.messageLength] = by;
        }
        ++this.messageLength;
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
        if (this.messageLength < this.mBuf.length) {
            for (int i2 = 0; i2 < n3 && i2 + this.messageLength < this.mBuf.length; ++i2) {
                this.mBuf[this.messageLength + i2] = byArray[n2 + i2];
            }
        }
        this.messageLength += n3;
    }

    public void reset() {
        this.digest.reset();
        this.messageLength = 0;
        this.clearBlock(this.mBuf);
        if (this.recoveredMessage != null) {
            this.clearBlock(this.recoveredMessage);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
    }

    public byte[] generateSignature() throws CryptoException {
        int n2;
        int n3 = this.digest.getDigestSize();
        int n4 = 0;
        int n5 = 0;
        if (this.trailer == 188) {
            n4 = 8;
            n5 = this.block.length - n3 - 1;
            this.digest.doFinal(this.block, n5);
            this.block[this.block.length - 1] = -68;
        } else {
            n4 = 16;
            n5 = this.block.length - n3 - 2;
            this.digest.doFinal(this.block, n5);
            this.block[this.block.length - 2] = (byte)(this.trailer >>> 8);
            this.block[this.block.length - 1] = (byte)this.trailer;
        }
        int n6 = 0;
        int n7 = (n3 + this.messageLength) * 8 + n4 + 4 - this.keyBits;
        if (n7 > 0) {
            n2 = this.messageLength - (n7 + 7) / 8;
            n6 = 96;
            System.arraycopy(this.mBuf, 0, this.block, n5 -= n2, n2);
        } else {
            n6 = 64;
            System.arraycopy(this.mBuf, 0, this.block, n5 -= this.messageLength, this.messageLength);
        }
        if (n5 - 1 > 0) {
            for (n2 = n5 - 1; n2 != 0; --n2) {
                this.block[n2] = -69;
            }
            int n8 = n5 - 1;
            this.block[n8] = (byte)(this.block[n8] ^ 1);
            this.block[0] = 11;
            this.block[0] = (byte)(this.block[0] | n6);
        } else {
            this.block[0] = 10;
            this.block[0] = (byte)(this.block[0] | n6);
        }
        byte[] byArray = this.cipher.processBlock(this.block, 0, this.block.length);
        this.clearBlock(this.mBuf);
        this.clearBlock(this.block);
        return byArray;
    }

    public boolean verifySignature(byte[] byArray) {
        int n2;
        byte[] byArray2 = null;
        try {
            byArray2 = this.cipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        int n3 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n3 = 1;
        } else {
            n2 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            switch (n2) {
                case 12748: {
                    if (this.digest instanceof RIPEMD160Digest) break;
                    throw new IllegalStateException("signer should be initialised with RIPEMD160");
                }
                case 13260: {
                    if (this.digest instanceof SHA1Digest) break;
                    throw new IllegalStateException("signer should be initialised with SHA1");
                }
                case 13004: {
                    if (this.digest instanceof RIPEMD128Digest) break;
                    throw new IllegalStateException("signer should be initialised with RIPEMD128");
                }
                default: {
                    throw new IllegalArgumentException("unrecognised hash in signature");
                }
            }
            n3 = 2;
        }
        n2 = 0;
        for (n2 = 0; n2 != byArray2.length && (byArray2[n2] & 0xF ^ 0xA) != 0; ++n2) {
        }
        byte[] byArray3 = new byte[this.digest.getDigestSize()];
        int n4 = byArray2.length - n3 - byArray3.length;
        if (n4 - ++n2 <= 0) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.fullMessage = true;
            this.digest.reset();
            this.digest.update(byArray2, n2, n4 - n2);
            this.digest.doFinal(byArray3, 0);
            for (int i2 = 0; i2 != byArray3.length; ++i2) {
                int n5 = n4 + i2;
                byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[i2]);
                if (byArray2[n4 + i2] == 0) continue;
                this.clearBlock(this.mBuf);
                this.clearBlock(byArray2);
                return false;
            }
            this.recoveredMessage = new byte[n4 - n2];
            System.arraycopy(byArray2, n2, this.recoveredMessage, 0, this.recoveredMessage.length);
        } else {
            this.fullMessage = false;
            this.digest.doFinal(byArray3, 0);
            for (int i3 = 0; i3 != byArray3.length; ++i3) {
                int n6 = n4 + i3;
                byArray2[n6] = (byte)(byArray2[n6] ^ byArray3[i3]);
                if (byArray2[n4 + i3] == 0) continue;
                this.clearBlock(this.mBuf);
                this.clearBlock(byArray2);
                return false;
            }
            this.recoveredMessage = new byte[n4 - n2];
            System.arraycopy(byArray2, n2, this.recoveredMessage, 0, this.recoveredMessage.length);
        }
        if (this.messageLength != 0 && !this.isSameAs(this.mBuf, this.recoveredMessage)) {
            this.clearBlock(this.mBuf);
            this.clearBlock(byArray2);
            return false;
        }
        this.clearBlock(this.mBuf);
        this.clearBlock(byArray2);
        return true;
    }

    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

