/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable hashtable) {
        this.attributes = this.copyTable(hashtable);
    }

    public AttributeTable(DEREncodableVector dEREncodableVector) {
        for (int i2 = 0; i2 != dEREncodableVector.size(); ++i2) {
            Attribute attribute = Attribute.getInstance(dEREncodableVector.get(i2));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(ASN1Set aSN1Set) {
        for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(i2));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    private void addAttribute(DERObjectIdentifier dERObjectIdentifier, Attribute attribute) {
        Object v2 = this.attributes.get(dERObjectIdentifier);
        if (v2 == null) {
            this.attributes.put(dERObjectIdentifier, attribute);
        } else {
            Vector<Object> vector;
            if (v2 instanceof Attribute) {
                vector = new Vector<Object>();
                vector.addElement(v2);
                vector.addElement(attribute);
            } else {
                vector = (Vector<Object>)v2;
                vector.addElement(attribute);
            }
            this.attributes.put(dERObjectIdentifier, vector);
        }
    }

    public Attribute get(DERObjectIdentifier dERObjectIdentifier) {
        Object v2 = this.attributes.get(dERObjectIdentifier);
        if (v2 instanceof Vector) {
            return (Attribute)((Vector)v2).elementAt(0);
        }
        return (Attribute)v2;
    }

    public ASN1EncodableVector getAll(DERObjectIdentifier dERObjectIdentifier) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object v2 = this.attributes.get(dERObjectIdentifier);
        if (v2 instanceof Vector) {
            Enumeration enumeration = ((Vector)v2).elements();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((Attribute)enumeration.nextElement());
            }
        } else if (v2 != null) {
            aSN1EncodableVector.add((Attribute)v2);
        }
        return aSN1EncodableVector;
    }

    public Hashtable toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Object v2 = enumeration.nextElement();
            if (v2 instanceof Vector) {
                Enumeration enumeration2 = ((Vector)v2).elements();
                while (enumeration2.hasMoreElements()) {
                    aSN1EncodableVector.add(Attribute.getInstance(enumeration2.nextElement()));
                }
                continue;
            }
            aSN1EncodableVector.add(Attribute.getInstance(v2));
        }
        return aSN1EncodableVector;
    }

    private Hashtable copyTable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable2.put(k2, hashtable.get(k2));
        }
        return hashtable2;
    }
}

