/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERUniversalString
extends ASN1Object
implements DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] string;

    public static DERUniversalString getInstance(Object object) {
        if (object == null || object instanceof DERUniversalString) {
            return (DERUniversalString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUniversalString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERUniversalString(byte[] byArray) {
        this.string = byArray;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            stringBuffer.append(table[byArray[i2] >>> 4 & 0xF]);
            stringBuffer.append(table[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(28, this.getOctets());
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)dERObject).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

