/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public abstract class AbstractXlsServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = 10200L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<JasperPrint> jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        Boolean isBuffered = Boolean.valueOf(request.getParameter("buffered"));
        if (isBuffered.booleanValue()) {
            FileBufferedOutputStream fbos = new FileBufferedOutputStream();
            JRXlsAbstractExporter exporter = this.getXlsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintList);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, fbos);
            exporter.setParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
            exporter.setParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
            try {
                exporter.exportReport();
                fbos.close();
                if (fbos.size() <= 0) return;
                response.setContentType(this.getResponseContentType());
                this.setResponseHeader(response);
                response.setContentLength(fbos.size());
                ServletOutputStream ouputStream = response.getOutputStream();
                try {
                    fbos.writeData((OutputStream)ouputStream);
                    fbos.dispose();
                    ouputStream.flush();
                    return;
                }
                finally {
                    if (ouputStream != null) {
                        try {
                            ouputStream.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            catch (JRException e2) {
                throw new ServletException((Throwable)e2);
            }
            finally {
                fbos.close();
                fbos.dispose();
            }
        }
        response.setContentType(this.getResponseContentType());
        this.setResponseHeader(response);
        JRXlsAbstractExporter exporter = this.getXlsExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintList);
        ServletOutputStream ouputStream = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, ouputStream);
        exporter.setParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
        exporter.setParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
        try {
            exporter.exportReport();
            return;
        }
        catch (JRException e3) {
            throw new ServletException((Throwable)e3);
        }
        finally {
            if (ouputStream != null) {
                try {
                    ouputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected abstract JRXlsAbstractExporter getXlsExporter();

    protected String getResponseContentType() {
        return "application/xls";
    }

    protected void setResponseHeader(HttpServletResponse response) {
        response.setHeader("Content-Disposition", "inline; filename=\"file.xls\"");
    }
}

