/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class JRPrintTextFactory
extends JRBaseFactory {
    private static final Log log = LogFactory.getLog(JRPrintTextFactory.class);

    @Override
    public Object createObject(Attributes atts) {
        String timezone;
        String locale;
        String formatFactoryClass;
        String pattern;
        String valueClass;
        String leadingOffset;
        String lineSpacingFactor;
        LineSpacingEnum lineSpacing;
        String textHeight;
        RunDirectionEnum runDirection;
        RotationEnum rotation;
        VerticalAlignEnum verticalAlignment;
        JasperPrint jasperPrint = (JasperPrint)this.digester.peek(this.digester.getCount() - 2);
        JRBasePrintText text = new JRBasePrintText(jasperPrint.getDefaultStyleProvider());
        HorizontalAlignEnum horizontalAlignment = HorizontalAlignEnum.getByName(atts.getValue("textAlignment"));
        if (horizontalAlignment != null) {
            text.setHorizontalAlignment(horizontalAlignment);
        }
        if ((verticalAlignment = VerticalAlignEnum.getByName(atts.getValue("verticalAlignment"))) != null) {
            text.setVerticalAlignment(verticalAlignment);
        }
        if ((rotation = RotationEnum.getByName(atts.getValue("rotation"))) != null) {
            text.setRotation(rotation);
        }
        if ((runDirection = RunDirectionEnum.getByName(atts.getValue("runDirection"))) != null) {
            text.setRunDirection(runDirection);
        }
        if ((textHeight = atts.getValue("textHeight")) != null && textHeight.length() > 0) {
            text.setTextHeight(Float.parseFloat(textHeight));
        }
        if ((lineSpacing = LineSpacingEnum.getByName(atts.getValue("lineSpacing"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'lineSpacing' attribute is deprecated. Use the <paragraph> tag instead.");
            }
            text.getParagraph().setLineSpacing(lineSpacing);
        }
        text.setMarkup(atts.getValue("markup"));
        String isStyledText = atts.getValue("isStyledText");
        if (isStyledText != null && isStyledText.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'isStyledText' attribute is deprecated. Use the 'markup' attribute instead.");
            }
            text.setMarkup(Boolean.valueOf(isStyledText) != false ? "styled" : "none");
        }
        if ((lineSpacingFactor = atts.getValue("lineSpacingFactor")) != null && lineSpacingFactor.length() > 0) {
            text.setLineSpacingFactor(Float.parseFloat(lineSpacingFactor));
        }
        if ((leadingOffset = atts.getValue("leadingOffset")) != null && leadingOffset.length() > 0) {
            text.setLeadingOffset(Float.parseFloat(leadingOffset));
        }
        text.setLinkType(atts.getValue("hyperlinkType"));
        text.setLinkTarget(atts.getValue("hyperlinkTarget"));
        text.setAnchorName(atts.getValue("anchorName"));
        text.setHyperlinkReference(atts.getValue("hyperlinkReference"));
        text.setHyperlinkAnchor(atts.getValue("hyperlinkAnchor"));
        String hyperlinkPage = atts.getValue("hyperlinkPage");
        if (hyperlinkPage != null) {
            text.setHyperlinkPage(Integer.valueOf(hyperlinkPage));
        }
        text.setHyperlinkTooltip(atts.getValue("hyperlinkTooltip"));
        String bookmarkLevelAttr = atts.getValue("bookmarkLevel");
        if (bookmarkLevelAttr != null) {
            text.setBookmarkLevel(Integer.parseInt(bookmarkLevelAttr));
        }
        if ((valueClass = atts.getValue("valueClass")) != null) {
            text.setValueClassName(valueClass);
        }
        if ((pattern = atts.getValue("pattern")) != null) {
            text.setPattern(pattern);
        }
        if ((formatFactoryClass = atts.getValue("formatFactoryClass")) != null) {
            text.setFormatFactoryClass(formatFactoryClass);
        }
        if ((locale = atts.getValue("locale")) != null) {
            text.setLocaleCode(locale);
        }
        if ((timezone = atts.getValue("timezone")) != null) {
            text.setTimeZoneId(timezone);
        }
        return text;
    }
}

