/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.color.ICC_Profile;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.FontKey;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.export.PdfFont;
import net.sf.jasperreports.engine.export.PdfTextRenderer;
import net.sf.jasperreports.engine.export.SimplePdfTextRenderer;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRPdfaIccProfileNotFoundException;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPdfExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JRPdfExporter.class);
    public static final String PDF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pdf.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.pdf.ignore.hyperlink";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String PDF_EXPORTER_KEY = "net.sf.jasperreports.pdf";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered;
    protected Document document;
    protected PdfContentByte pdfContentByte;
    protected PdfWriter pdfWriter;
    protected Document imageTesterDocument;
    protected PdfContentByte imageTesterPdfContentByte;
    protected JRPdfExporterTagHelper tagHelper = new JRPdfExporterTagHelper(this);
    protected JRExportProgressMonitor progressMonitor;
    protected int reportIndex;
    protected boolean forceSvgShapes;
    protected boolean isCreatingBatchModeBookmarks;
    protected boolean isCompressed;
    protected boolean isEncrypted;
    protected boolean is128BitKey;
    protected String userPassword;
    protected String ownerPassword;
    protected int permissions;
    protected Character pdfVersion;
    protected String pdfJavaScript;
    protected String printScaling;
    private boolean collapseMissingBookmarkLevels;
    protected Map<Renderable, Image> loadedImagesMap;
    protected Image pxImage;
    private BookmarkStack bookmarkStack;
    private Map<FontKey, PdfFont> pdfFontMap;
    private SplitCharacter splitCharacter;
    protected JRPdfExporterContext exporterContext = new ExporterContext();

    public JRPdfExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPdfExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance(JRLoader.loadBytesFromResource("net/sf/jasperreports/engine/images/pixel.GIF"));
            }
            catch (Exception e2) {
                throw new JRRuntimeException(e2);
            }
        }
        return this.pxImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block20: {
            JRPdfExporter.registerFonts();
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(PDF_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.isCreatingBatchModeBookmarks = this.getBooleanParameter(JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS, "net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", false);
                this.forceSvgShapes = this.getBooleanParameter(JRPdfExporterParameter.FORCE_SVG_SHAPES, "net.sf.jasperreports.export.pdf.force.svg.shapes", false);
                this.isCompressed = this.getBooleanParameter(JRPdfExporterParameter.IS_COMPRESSED, "net.sf.jasperreports.export.pdf.compressed", false);
                this.isEncrypted = this.getBooleanParameter(JRPdfExporterParameter.IS_ENCRYPTED, "net.sf.jasperreports.export.pdf.encrypted", false);
                this.is128BitKey = this.getBooleanParameter(JRPdfExporterParameter.IS_128_BIT_KEY, "net.sf.jasperreports.export.pdf.128.bit.key", false);
                this.userPassword = this.getStringParameter(JRPdfExporterParameter.USER_PASSWORD, "net.sf.jasperreports.export.pdf.user.password");
                this.ownerPassword = this.getStringParameter(JRPdfExporterParameter.OWNER_PASSWORD, "net.sf.jasperreports.export.pdf.owner.password");
                Integer permissionsParameter = (Integer)this.parameters.get(JRPdfExporterParameter.PERMISSIONS);
                if (permissionsParameter != null) {
                    this.permissions = permissionsParameter;
                }
                this.pdfVersion = this.getCharacterParameter(JRPdfExporterParameter.PDF_VERSION, "net.sf.jasperreports.export.pdf.version");
                this.setFontMap();
                this.setSplitCharacter();
                this.setHyperlinkProducerFactory();
                this.pdfJavaScript = this.getStringParameter(JRPdfExporterParameter.PDF_JAVASCRIPT, "net.sf.jasperreports.export.pdf.javascript");
                this.printScaling = this.getStringParameter(JRPdfExporterParameter.PRINT_SCALING, "net.sf.jasperreports.export.pdf.print.scaling");
                this.tagHelper.setTagged(this.getBooleanParameter(JRPdfExporterParameter.IS_TAGGED, "net.sf.jasperreports.export.pdf.tagged", false));
                this.collapseMissingBookmarkLevels = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.pdf.collapse.missing.bookmark.levels", false);
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block20;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e2) {
                    throw new JRException("Error trying to export to file : " + destFile, e2);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e3) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    @Override
    protected void setFontMap() {
        this.pdfFontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
    }

    protected void setSplitCharacter() {
        Boolean useFillSplitCharacterParam = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_LINEBREAK_POLICY);
        boolean useFillSplitCharacter = useFillSplitCharacterParam == null ? JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint.getPropertiesMap(), "net.sf.jasperreports.export.pdf.force.linebreak.policy", false) : useFillSplitCharacterParam.booleanValue();
        if (useFillSplitCharacter) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        boolean closeDocuments = true;
        try {
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            this.pdfWriter = PdfWriter.getInstance(this.document, os);
            this.pdfWriter.setCloseStream(false);
            this.tagHelper.setPdfWriter(this.pdfWriter);
            if (this.pdfVersion != null) {
                this.pdfWriter.setPdfVersion(this.pdfVersion.charValue());
            }
            if (this.isCompressed) {
                this.pdfWriter.setFullCompression();
            }
            if (this.isEncrypted) {
                this.pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            if (this.printScaling != null) {
                if ("default".equals(this.printScaling)) {
                    this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, PdfName.APPDEFAULT);
                } else if ("none".equals(this.printScaling)) {
                    this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, PdfName.NONE);
                }
            }
            if ((title = (String)this.parameters.get(JRPdfExporterParameter.METADATA_TITLE)) != null) {
                this.document.addTitle(title);
            }
            if ((author = (String)this.parameters.get(JRPdfExporterParameter.METADATA_AUTHOR)) != null) {
                this.document.addAuthor(author);
            }
            if ((subject = (String)this.parameters.get(JRPdfExporterParameter.METADATA_SUBJECT)) != null) {
                this.document.addSubject(subject);
            }
            if ((keywords = (String)this.parameters.get(JRPdfExporterParameter.METADATA_KEYWORDS)) != null) {
                this.document.addKeywords(keywords);
            }
            if ((creator = (String)this.parameters.get(JRPdfExporterParameter.METADATA_CREATOR)) != null) {
                this.document.addCreator(creator);
            } else {
                this.document.addCreator("JasperReports (" + this.jasperPrint.getName() + ")");
            }
            String pdfaConformance = this.getStringParameter(JRPdfExporterParameter.PDFA_CONFORMANCE, "net.sf.jasperreports.export.pdfa.conformance");
            boolean gotPdfa = false;
            if (pdfaConformance != null && !"none".equalsIgnoreCase(pdfaConformance)) {
                if ("pdfa1a".equalsIgnoreCase(pdfaConformance)) {
                    this.pdfWriter.setPDFXConformance(3);
                    gotPdfa = true;
                } else if ("pdfa1b".equalsIgnoreCase(pdfaConformance)) {
                    this.pdfWriter.setPDFXConformance(4);
                    gotPdfa = true;
                }
            }
            if (gotPdfa) {
                this.pdfWriter.createXmpMetadata();
            } else {
                this.pdfWriter.setRgbTransparencyBlending(true);
            }
            this.document.open();
            if (gotPdfa) {
                String iccProfilePath = this.getStringParameter(JRPdfExporterParameter.PDFA_ICC_PROFILE_PATH, "net.sf.jasperreports.export.pdfa.icc.profile.path");
                if (iccProfilePath != null) {
                    PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
                    pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString("sRGB IEC61966-2.1"));
                    pdfDictionary.put(PdfName.INFO, new PdfString("sRGB IEC61966-2.1"));
                    pdfDictionary.put(PdfName.S, PdfName.GTS_PDFA1);
                    InputStream iccIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(iccProfilePath);
                    PdfICCBased pdfICCBased = new PdfICCBased(ICC_Profile.getInstance(iccIs));
                    pdfICCBased.remove(PdfName.ALTERNATE);
                    pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, this.pdfWriter.addToBody(pdfICCBased).getIndirectReference());
                    this.pdfWriter.getExtraCatalog().put(PdfName.OUTPUTINTENTS, new PdfArray(pdfDictionary));
                } else {
                    throw new JRPdfaIccProfileNotFoundException();
                }
            }
            if (this.pdfJavaScript != null) {
                this.pdfWriter.addJavaScript(this.pdfJavaScript);
            }
            this.pdfContentByte = this.pdfWriter.getDirectContent();
            this.tagHelper.init(this.pdfContentByte);
            this.initBookmarks();
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance(this.imageTesterDocument, new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
                this.loadedImagesMap = new HashMap<Renderable, Image>();
                this.setPageSize(null);
                BorderOffset.setLegacy(JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.legacy.border.offset", false));
                boolean sizePageToContent = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.pdf.size.page.to.content", false);
                List<JRPrintPage> pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        if (this.isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                        this.startPageIndex = 0;
                        this.endPageIndex = pages.size() - 1;
                    }
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = pages.get(pageIndex);
                        if (sizePageToContent) {
                            this.setPageSize(page);
                        }
                        this.document.newPage();
                        this.pdfContentByte = this.pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        this.writePageAnchor(pageIndex);
                        this.exportPage(page);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = this.pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException e2) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e2);
        }
        catch (IOException e3) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e3);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.document.close();
                }
                catch (Exception e4) {}
                try {
                    this.imageTesterDocument.close();
                }
                catch (Exception e5) {}
            }
        }
    }

    protected void writePageAnchor(int pageIndex) throws DocumentException {
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(attributes, new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
        com.lowagie.text.Font pdfFont = this.getFont(attributes, this.getLocale(), false);
        Chunk chunk = new Chunk(" ", pdfFont);
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
        this.tagHelper.startPageAnchor();
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(new Phrase(chunk), 0.0f, this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
        colText.go();
        this.tagHelper.endPageAnchor();
    }

    protected void setPageSize(JRPrintPage page) throws JRException, DocumentException, IOException {
        Rectangle pageSize;
        int pageWidth = this.jasperPrint.getPageWidth();
        int pageHeight = this.jasperPrint.getPageHeight();
        if (page != null) {
            List<JRPrintElement> elements = page.getElements();
            for (JRPrintElement element : elements) {
                int elementRight = element.getX() + element.getWidth();
                int elementBottom = element.getY() + element.getHeight();
                pageWidth = pageWidth < elementRight ? elementRight : pageWidth;
                pageHeight = pageHeight < elementBottom ? elementBottom : pageHeight;
            }
            pageWidth += this.jasperPrint.getRightMargin().intValue();
            pageHeight += this.jasperPrint.getBottomMargin().intValue();
        }
        switch (this.jasperPrint.getOrientationValue()) {
            case LANDSCAPE: {
                pageSize = new Rectangle(pageHeight, pageWidth).rotate();
                break;
            }
            default: {
                pageSize = new Rectangle(pageWidth, pageHeight);
            }
        }
        this.document.setPageSize(pageSize);
    }

    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        this.tagHelper.startPage();
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
        this.tagHelper.endPage();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws DocumentException, IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.tagHelper.startElement(element);
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                } else if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                } else if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                } else if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                } else if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                } else if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                } else if (element instanceof JRGenericPrintElement) {
                    this.exportGenericElement((JRGenericPrintElement)element);
                }
                this.tagHelper.endElement(element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        float lineWidth = line.getLinePen().getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, line.getLinePen(), 0);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                        this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + 0.5f - lineWidth / 3.0f, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
                        this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX()) + 0.5f - lineWidth / 3.0f, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight());
                        this.pdfContentByte.stroke();
                        this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + 0.5f + lineWidth / 3.0f, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
                        this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX()) + 0.5f + lineWidth / 3.0f, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight());
                    } else {
                        this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + 0.5f, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
                        this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX()) + 0.5f, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight());
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth(), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f - lineWidth / 3.0f);
                    this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth(), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f - lineWidth / 3.0f);
                } else {
                    this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f);
                    this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth(), (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - 0.5f);
                }
            } else if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) + (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) + (float)ytrans);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) - (float)ytrans);
                } else {
                    this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
                    this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth(), this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight());
                }
            } else if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) - (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) + (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) - (float)ytrans);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(line.getX() + this.getOffsetX()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight()) + (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + this.getOffsetX() + line.getWidth()) - (float)xtrans, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY()) + (float)ytrans);
            } else {
                this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight());
                this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth(), this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.setLineCap(2);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, rectangle.getLinePen(), 2);
        float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
        float lineOffset = BorderOffset.getOffset(rectangle.getLinePen());
        if (rectangle.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.roundRectangle(rectangle.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (rectangle.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) - lineWidth / 3.0f, (float)rectangle.getWidth() + 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() + 2.0f * lineWidth / 3.0f, rectangle.getRadius());
                this.pdfContentByte.stroke();
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) + lineWidth / 3.0f, (float)rectangle.getWidth() - 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() - 2.0f * lineWidth / 3.0f, rectangle.getRadius());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) + lineOffset, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) + lineOffset, (float)rectangle.getWidth() - 2.0f * lineOffset, (float)rectangle.getHeight() - 2.0f * lineOffset, rectangle.getRadius());
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, ellipse.getLinePen(), 2);
        float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
        float lineOffset = BorderOffset.getOffset(ellipse.getLinePen());
        if (ellipse.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.ellipse(ellipse.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight(), ellipse.getX() + this.getOffsetX() + ellipse.getWidth(), this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY());
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (ellipse.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) - lineWidth / 3.0f, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) + lineWidth / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) + lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) + lineWidth / 3.0f, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) - lineWidth / 3.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) - lineWidth / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) + lineOffset, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) + lineOffset, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) - lineOffset, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) - lineOffset);
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    public void exportImage(JRPrintImage printImage) throws DocumentException, IOException, JRException {
        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.rectangle(printImage.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - printImage.getY() - this.getOffsetY(), printImage.getWidth(), -printImage.getHeight());
            this.pdfContentByte.fill();
        }
        int topPadding = printImage.getLineBox().getTopPadding();
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        Renderable renderer = printImage.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, printImage.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int xoffset = 0;
            int yoffset = 0;
            Chunk chunk = null;
            float scaledWidth = availableImageWidth;
            float scaledHeight = availableImageHeight;
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                Image image = null;
                float xalignFactor = this.getXAlignFactor(printImage);
                float yalignFactor = this.getYAlignFactor(printImage);
                switch (printImage.getScaleImageValue()) {
                    case CLIP: {
                        renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, printImage.getOnErrorTypeValue());
                        if (renderer == null) break;
                        int normalWidth = availableImageWidth;
                        int normalHeight = availableImageHeight;
                        Dimension2D dimension = renderer.getDimension(this.jasperReportsContext);
                        if (dimension != null) {
                            normalWidth = (int)dimension.getWidth();
                            normalHeight = (int)dimension.getHeight();
                        }
                        xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        int minWidth = Math.min(normalWidth, availableImageWidth);
                        int minHeight = Math.min(normalHeight, availableImageHeight);
                        BufferedImage bi = new BufferedImage(minWidth, minHeight, 2);
                        Graphics2D g2 = bi.createGraphics();
                        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
                            g2.setColor(printImage.getBackcolor());
                            g2.fillRect(0, 0, minWidth, minHeight);
                        }
                        renderer.render(this.jasperReportsContext, g2, new java.awt.Rectangle(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight));
                        g2.dispose();
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                        image = Image.getInstance(bi, null);
                        break;
                    }
                    case FILL_FRAME: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance(renderer.getImageData(this.jasperReportsContext));
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e2) {
                                JRImageRenderer tmpRenderer = JRImageRenderer.getOnErrorRendererForImage(this.jasperReportsContext, JRImageRenderer.getInstance(renderer.getImageData(this.jasperReportsContext)), printImage.getOnErrorTypeValue());
                                if (tmpRenderer == null) break;
                                java.awt.Image awtImage = tmpRenderer.getImage(this.jasperReportsContext);
                                image = Image.getInstance(awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleAbsolute(availableImageWidth, availableImageHeight);
                        break;
                    }
                    default: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance(renderer.getImageData(this.jasperReportsContext));
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e3) {
                                JRImageRenderer tmpRenderer = JRImageRenderer.getOnErrorRendererForImage(this.jasperReportsContext, JRImageRenderer.getInstance(renderer.getImageData(this.jasperReportsContext)), printImage.getOnErrorTypeValue());
                                if (tmpRenderer == null) break;
                                java.awt.Image awtImage = tmpRenderer.getImage(this.jasperReportsContext);
                                image = Image.getInstance(awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleToFit(availableImageWidth, availableImageHeight);
                        xoffset = (int)(xalignFactor * ((float)availableImageWidth - image.getPlainWidth()));
                        yoffset = (int)(yalignFactor * ((float)availableImageHeight - image.getPlainHeight()));
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        int n2 = yoffset = yoffset < 0 ? 0 : yoffset;
                    }
                }
                if (image != null) {
                    chunk = new Chunk(image, 0.0f, 0.0f);
                    scaledWidth = image.getScaledWidth();
                    scaledHeight = image.getScaledHeight();
                }
            } else {
                Graphics2D g3;
                double normalWidth = availableImageWidth;
                double normalHeight = availableImageHeight;
                double displayWidth = availableImageWidth;
                double displayHeight = availableImageHeight;
                double ratioX = 1.0;
                double ratioY = 1.0;
                Rectangle2D.Double clip = null;
                Dimension2D dimension = renderer.getDimension(this.jasperReportsContext);
                if (dimension != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                    displayWidth = normalWidth;
                    displayHeight = normalHeight;
                    float xalignFactor = this.getXAlignFactor(printImage);
                    float yalignFactor = this.getYAlignFactor(printImage);
                    switch (printImage.getScaleImageValue()) {
                        case CLIP: {
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - normalWidth));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - normalHeight));
                            clip = new Rectangle2D.Double(-xoffset, -yoffset, availableImageWidth, availableImageHeight);
                            break;
                        }
                        case FILL_FRAME: {
                            ratioX = (double)availableImageWidth / normalWidth;
                            ratioY = (double)availableImageHeight / normalHeight;
                            normalWidth *= ratioX;
                            normalHeight *= ratioY;
                            xoffset = 0;
                            yoffset = 0;
                            break;
                        }
                        default: {
                            ratioX = (double)availableImageWidth / normalWidth;
                            ratioY = (double)availableImageHeight / normalHeight;
                            ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - (normalWidth *= ratioX)));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - (normalHeight *= ratioY)));
                        }
                    }
                }
                PdfTemplate template = this.pdfContentByte.createTemplate((float)displayWidth, (float)displayHeight);
                Graphics2D graphics2D = g3 = this.forceSvgShapes ? template.createGraphicsShapes((float)displayWidth, (float)displayHeight) : template.createGraphics(availableImageWidth, availableImageHeight, new LocalFontMapper());
                if (clip != null) {
                    g3.setClip(clip);
                }
                if (printImage.getModeValue() == ModeEnum.OPAQUE) {
                    g3.setColor(printImage.getBackcolor());
                    g3.fillRect(0, 0, (int)displayWidth, (int)displayHeight);
                }
                Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, displayWidth, displayHeight);
                renderer.render(this.jasperReportsContext, g3, rectangle);
                g3.dispose();
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(template, (float)ratioX, 0.0f, 0.0f, (float)ratioY, printImage.getX() + this.getOffsetX() + xoffset, this.jasperPrint.getPageHeight() - printImage.getY() - this.getOffsetY() - (int)normalHeight - yoffset);
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute(availableImageWidth, availableImageHeight);
                chunk = new Chunk(image, 0.0f, 0.0f);
                this.pdfWriter.releaseTemplate(template);
            }
            if (chunk != null) {
                this.setAnchor(chunk, printImage, printImage);
                this.setHyperlinkInfo(chunk, printImage);
                this.tagHelper.startImage(printImage);
                ColumnText colText = new ColumnText(this.pdfContentByte);
                int upperY = this.jasperPrint.getPageHeight() - printImage.getY() - topPadding - this.getOffsetY() - yoffset;
                int lowerX = printImage.getX() + leftPadding + this.getOffsetX() + xoffset;
                colText.setSimpleColumn(new Phrase(chunk), lowerX, (float)upperY - scaledHeight, (float)lowerX + scaledWidth, upperY, scaledHeight, 0);
                colText.go();
                this.tagHelper.endImage();
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), printImage);
            }
        } else {
            this.exportBox(printImage.getLineBox(), printImage);
        }
    }

    private float getXAlignFactor(JRPrintImage printImage) {
        float xalignFactor = 0.0f;
        switch (printImage.getHorizontalAlignmentValue()) {
            case RIGHT: {
                xalignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage printImage) {
        float yalignFactor = 0.0f;
        switch (printImage.getVerticalAlignmentValue()) {
            case BOTTOM: {
                yalignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink link) {
        if (link != null) {
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint, PROPERTY_IGNORE_HYPERLINK, false);
            }
            if (!ignoreHyperlink.booleanValue()) {
                block0 : switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() == null) break;
                        switch (link.getHyperlinkTargetValue()) {
                            case BLANK: {
                                chunk.setAction(PdfAction.javaScript("if (app.viewerVersion < 7){this.getURL(\"" + link.getHyperlinkReference() + "\");}" + "else {app.launchURL(\"" + link.getHyperlinkReference() + "\", true);};", this.pdfWriter));
                                break block0;
                            }
                        }
                        chunk.setAnchor(link.getHyperlinkReference());
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() == null) break;
                        chunk.setLocalGoto(link.getHyperlinkAnchor());
                        break;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() == null) break;
                        chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                        break;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage());
                        break;
                    }
                    case CUSTOM: {
                        String hyperlink;
                        if (this.hyperlinkProducerFactory == null || (hyperlink = this.hyperlinkProducerFactory.produceHyperlink(link)) == null) break;
                        switch (link.getHyperlinkTargetValue()) {
                            case BLANK: {
                                chunk.setAction(PdfAction.javaScript("if (app.viewerVersion < 7){this.getURL(\"" + hyperlink + "\");}" + "else {app.launchURL(\"" + hyperlink + "\", true);};", this.pdfWriter));
                                break block0;
                            }
                        }
                        chunk.setAnchor(hyperlink);
                    }
                }
            }
        }
    }

    protected Phrase getPhrase(AttributedString as, String text, JRPrintText textElement) {
        Phrase phrase = new Phrase();
        int runLimit = 0;
        AttributedCharacterIterator iterator = as.getIterator();
        Locale locale = this.getTextLocale(textElement);
        boolean firstChunk = true;
        while (runLimit < text.length() && (runLimit = iterator.getRunLimit()) <= text.length()) {
            JRPrintHyperlink hyperlink;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Chunk chunk = this.getChunk(attributes, text.substring(iterator.getIndex(), runLimit), locale);
            if (firstChunk) {
                this.setAnchor(chunk, textElement, textElement);
            }
            if ((hyperlink = textElement).getHyperlinkTypeValue() == HyperlinkTypeEnum.NONE) {
                hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
            }
            this.setHyperlinkInfo(chunk, hyperlink);
            phrase.add(chunk);
            iterator.setIndex(runLimit);
            firstChunk = false;
        }
        return phrase;
    }

    protected Chunk getChunk(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        Object script;
        Color backcolor;
        com.lowagie.text.Font font = this.getFont(attributes, locale, false);
        Chunk chunk = new Chunk(text, font);
        if (this.hasUnderline(attributes)) {
            chunk.setUnderline(null, 0.0f, 0.055555556f, 0.0f, -0.083333336f, 0);
        }
        if (this.hasStrikethrough(attributes)) {
            chunk.setUnderline(null, 0.0f, 0.055555556f, 0.0f, 0.33333334f, 0);
        }
        if ((backcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setTextRise(font.getCalculatedLeading(1.0f) / 2.0f);
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setTextRise(-font.getCalculatedLeading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    protected boolean hasUnderline(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Integer underline = (Integer)textAttributes.get(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(underline);
    }

    protected boolean hasStrikethrough(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Boolean strike = (Boolean)textAttributes.get(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(strike);
    }

    protected com.lowagie.text.Font getFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        float fontSizeScale = 1.0f;
        Integer scriptStyle = (Integer)attributes.get(TextAttribute.SUPERSCRIPT);
        if (scriptStyle != null && (TextAttribute.SUPERSCRIPT_SUB.equals(scriptStyle) || TextAttribute.SUPERSCRIPT_SUPER.equals(scriptStyle))) {
            fontSizeScale = 0.6666667f;
        }
        com.lowagie.text.Font font = null;
        PdfFont pdfFont = null;
        FontKey key = new FontKey(jrFont.getFontName(), jrFont.isBold(), jrFont.isItalic());
        if (this.fontMap != null && this.fontMap.containsKey(key)) {
            pdfFont = this.pdfFontMap.get(key);
        } else {
            FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(jrFont.getFontName(), locale);
            if (fontInfo == null) {
                pdfFont = new PdfFont(jrFont.getPdfFontName(), jrFont.getPdfEncoding(), jrFont.isPdfEmbedded());
            } else {
                FontFamily family = fontInfo.getFontFamily();
                FontFace face = fontInfo.getFontFace();
                int faceStyle = 0;
                if (face == null) {
                    if (jrFont.isBold() && jrFont.isItalic()) {
                        face = family.getBoldItalicFace();
                        faceStyle = 3;
                    }
                    if (face == null && jrFont.isBold()) {
                        face = family.getBoldFace();
                        faceStyle = 1;
                    }
                    if (face == null && jrFont.isItalic()) {
                        face = family.getItalicFace();
                        faceStyle = 2;
                    }
                    if (face == null) {
                        face = family.getNormalFace();
                        faceStyle = 0;
                    }
                } else {
                    faceStyle = fontInfo.getStyle();
                }
                String pdfFontName = null;
                int pdfFontStyle = 0;
                if (jrFont.isBold() && jrFont.isItalic()) {
                    pdfFontName = family.getBoldItalicPdfFont();
                    pdfFontStyle = 3;
                }
                if (pdfFontName == null && jrFont.isBold()) {
                    pdfFontName = family.getBoldPdfFont();
                    pdfFontStyle = 1;
                }
                if (pdfFontName == null && jrFont.isItalic()) {
                    pdfFontName = family.getItalicPdfFont();
                    pdfFontStyle = 2;
                }
                if (pdfFontName == null) {
                    pdfFontName = family.getNormalPdfFont();
                    pdfFontStyle = 0;
                }
                if (pdfFontName == null) {
                    pdfFontName = face == null || face.getFile() == null ? jrFont.getPdfFontName() : face.getFile();
                    pdfFontStyle = faceStyle;
                }
                pdfFont = new PdfFont(pdfFontName, family.getPdfEncoding() == null ? jrFont.getPdfEncoding() : family.getPdfEncoding(), family.isPdfEmbedded() == null ? jrFont.isPdfEmbedded() : family.isPdfEmbedded().booleanValue(), jrFont.isBold() && (pdfFontStyle & 1) == 0, jrFont.isItalic() && (pdfFontStyle & 2) == 0);
            }
        }
        int pdfFontStyle = (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0);
        if (setFontLines) {
            pdfFontStyle |= (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0);
        }
        try {
            font = FontFactory.getFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), (float)jrFont.getFontSize() * fontSizeScale, pdfFontStyle, forecolor);
            if (font.getBaseFont() == null && font.getFamily() == -1) {
                font = null;
            }
        }
        catch (Exception e2) {
            initialException = e2;
        }
        if (font == null) {
            byte[] bytes = null;
            try {
                bytes = RepositoryUtil.getInstance(this.jasperReportsContext).getBytesFromLocation(pdfFont.getPdfFontName());
            }
            catch (JRException e3) {
                throw new JRRuntimeException("Could not load the following font : \npdfFontName   : " + pdfFont.getPdfFontName() + "\npdfEncoding   : " + pdfFont.getPdfEncoding() + "\nisPdfEmbedded : " + pdfFont.isPdfEmbedded(), initialException);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), true, bytes, null);
            }
            catch (DocumentException e4) {
                throw new JRRuntimeException(e4);
            }
            catch (IOException e5) {
                throw new JRRuntimeException(e5);
            }
            font = new com.lowagie.text.Font(baseFont, (float)jrFont.getFontSize() * fontSizeScale, pdfFontStyle, forecolor);
        }
        return font;
    }

    public void exportText(JRPrintText text) throws DocumentException {
        AbstractPdfTextRenderer textRenderer = text.getLeadingOffset() == 0.0f ? new PdfTextRenderer(this.jasperReportsContext, this.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font")) : new SimplePdfTextRenderer(this.jasperReportsContext, this.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
        textRenderer.initialize(this, this.pdfContentByte, text, this.getOffsetX(), this.getOffsetY());
        JRStyledText styledText = textRenderer.getStyledText();
        if (styledText == null) {
            return;
        }
        double angle = 0.0;
        switch (text.getRotationValue()) {
            case LEFT: {
                angle = 1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = -1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, textRenderer.getX(), this.jasperPrint.getPageHeight() - textRenderer.getY());
        this.pdfContentByte.transform(atrans);
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            Color backcolor = text.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle(textRenderer.getX(), this.jasperPrint.getPageHeight() - textRenderer.getY(), textRenderer.getWidth(), -textRenderer.getHeight());
            this.pdfContentByte.fill();
        }
        if (styledText.length() > 0) {
            this.tagHelper.startText();
            textRenderer.render();
            this.tagHelper.endText();
        }
        atrans = new AffineTransform();
        atrans.rotate(-angle, textRenderer.getX(), this.jasperPrint.getPageHeight() - textRenderer.getY());
        this.pdfContentByte.transform(atrans);
        this.exportBox(text.getLineBox(), text);
    }

    protected void exportBox(JRLineBox box, JRPrintElement element) {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), element);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportPen(JRPen pen, JRPrintElement element) {
        this.exportTopPen(pen, pen, pen, element);
        this.exportLeftPen(pen, pen, pen, element);
        this.exportBottomPen(pen, pen, pen, element);
        this.exportRightPen(pen, pen, pen, element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element) {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(leftPen);
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(rightPen);
            JRPdfExporter.preparePen(this.pdfContentByte, topPen, 0);
            if (topPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float topOffset = topPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float topOffset = BorderOffset.getOffset(topPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element) {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(topPen);
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(bottomPen);
            JRPdfExporter.preparePen(this.pdfContentByte, leftPen, 0);
            if (leftPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float leftOffset = leftPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) - leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float leftOffset = BorderOffset.getOffset(leftPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) + leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(leftPen);
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(rightPen);
            JRPdfExporter.preparePen(this.pdfContentByte, bottomPen, 0);
            if (bottomPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float bottomOffset = bottomPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) + leftOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float bottomOffset = BorderOffset.getOffset(bottomPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - leftOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(topPen);
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f - BorderOffset.getOffset(bottomPen);
            JRPdfExporter.preparePen(this.pdfContentByte, rightPen, 0);
            if (rightPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float rightOffset = rightPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) + rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset / 3.0f, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                float rightOffset = BorderOffset.getOffset(rightPen);
                this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth()) - rightOffset, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    private static void preparePen(PdfContentByte pdfContentByte, JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return;
        }
        pdfContentByte.setLineWidth(lineWidth);
        pdfContentByte.setLineCap(lineCap);
        Color color = pen.getLineColor();
        pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                pdfContentByte.setLineWidth(lineWidth / 3.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case DOTTED: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(lineWidth, lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(0.0f, 2.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            case DASHED: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(5.0f * lineWidth, 3.0f * lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(4.0f * lineWidth, 4.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            default: {
                pdfContentByte.setLineDash(0.0f);
            }
        }
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List<JRPropertiesUtil.PropertySuffix> fontDirs;
            List<JRPropertiesUtil.PropertySuffix> fontFiles = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_FILES_PREFIX);
            if (!fontFiles.isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix font : fontFiles) {
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register(file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register(file, alias);
                }
            }
            if (!(fontDirs = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_DIRS_PREFIX)).isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix dir2 : fontDirs) {
                    FontFactory.registerDirectory(dir2.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks() {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = this.isModeBatch && this.isCreatingBatchModeBookmarks ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level >= level) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        if (!this.collapseMissingBookmarkLevels) {
            for (int i2 = parent.level + 1; i2 < level; ++i2) {
                Bookmark emptyBookmark = new Bookmark(parent, parent.pdfOutline.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
                this.bookmarkStack.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        Bookmark bookmark = new Bookmark(parent, x, this.jasperPrint.getPageHeight() - y, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(Chunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
            if (anchor.getBookmarkLevel() != 0) {
                this.addBookmark(anchor.getBookmarkLevel(), anchor.getAnchorName(), element.getX(), element.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws DocumentException, IOException, JRException {
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle(x, this.jasperPrint.getPageHeight() - y, frame.getWidth(), -frame.getHeight());
            this.pdfContentByte.fill();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame.getLineBox(), frame);
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPdfHandler handler = (GenericElementPdfHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), PDF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement(this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug("No PDF generic element handler for " + element.getGenericType());
        }
    }

    @Override
    protected String getExporterKey() {
        return PDF_EXPORTER_KEY;
    }

    class LocalFontMapper
    implements FontMapper {
        @Override
        public BaseFont awtToPdf(Font font) {
            HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            atts.putAll(font.getAttributes());
            return JRPdfExporter.this.getFont(atts, null, false).getBaseFont();
        }

        @Override
        public Font pdfToAwt(BaseFont font, int size) {
            return null;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int b2) {
        }

        @Override
        public void write(byte[] b2, int off, int len) {
        }

        @Override
        public void write(byte[] b2) {
        }
    }

    protected static class BookmarkStack {
        LinkedList<Bookmark> stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return this.stack.removeLast();
        }

        Bookmark peek() {
            return this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutline pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this(parent, new PdfDestination(0, x, top, 0.0f), title);
        }

        Bookmark(Bookmark parent, PdfDestination destination, String title) {
            this.pdfOutline = new PdfOutline(parent.pdfOutline, destination, title, false);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutline pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPdfExporterContext {
        protected ExporterContext() {
            super(JRPdfExporter.this);
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRPdfExporter.PDF_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public PdfWriter getPdfWriter() {
            return JRPdfExporter.this.pdfWriter;
        }
    }
}

