/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.IndexColumnValueIterator;

public class ObjectArrayValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private Object[] values;

    public ObjectArrayValues(Object[] values) {
        this.values = values;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.values.length);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            out.writeObject(this.values[i2]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.values = new Object[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.values[i2] = in.readObject();
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ColumnValuesIterator iterator() {
        return new ValuesIterator();
    }

    protected class ValuesIterator
    extends IndexColumnValueIterator {
        public ValuesIterator() {
            super(ObjectArrayValues.this.values.length);
        }

        @Override
        public Object get() {
            return ObjectArrayValues.this.values[this.currentIndex];
        }
    }
}

