/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseCrosstabBucket
implements JRCrosstabBucket,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String valueClassName;
    protected String valueClassRealName;
    protected Class<?> valueClass;
    protected SortOrderEnum orderValue = SortOrderEnum.ASCENDING;
    protected JRExpression expression;
    protected JRExpression orderByExpression;
    protected JRExpression comparatorExpression;
    private int PSEUDO_SERIAL_VERSION_UID = 50004;
    private byte order;

    protected JRBaseCrosstabBucket() {
    }

    public JRBaseCrosstabBucket(JRCrosstabBucket bucket, JRBaseObjectFactory factory) {
        factory.put(bucket, this);
        this.valueClassName = bucket.getValueClassName();
        this.orderValue = bucket.getOrderValue();
        this.expression = factory.getExpression(bucket.getExpression());
        this.orderByExpression = factory.getExpression(bucket.getOrderByExpression());
        this.comparatorExpression = factory.getExpression(bucket.getComparatorExpression());
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public SortOrderEnum getOrderValue() {
        return this.orderValue;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getOrderByExpression() {
        return this.orderByExpression;
    }

    @Override
    public JRExpression getComparatorExpression() {
        return this.comparatorExpression;
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException("Could not load bucket value class", e2);
            }
        }
        return this.valueClass;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    @Override
    public Object clone() {
        JRBaseCrosstabBucket clone = null;
        try {
            clone = (JRBaseCrosstabBucket)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.orderByExpression = JRCloneUtils.nullSafeClone(this.orderByExpression);
        clone.comparatorExpression = JRCloneUtils.nullSafeClone(this.comparatorExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.orderValue = SortOrderEnum.getByValue(this.order);
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 40003) {
            this.valueClassName = this.getExpression().getValueClassName();
        }
    }
}

