/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.AbstractBarcodeEvaluator;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class BarcodeEvaluator
extends AbstractBarcodeEvaluator {
    private final FillContext fillContext;
    private final byte evaluationType;

    public BarcodeEvaluator(FillContext fillContext, byte evaluationType) {
        super(fillContext.getFiller().getJasperReportsContext(), fillContext.getComponentElement(), fillContext.getDefaultStyleProvider());
        this.fillContext = fillContext;
        this.evaluationType = evaluationType;
    }

    protected void evaluateBaseBarcode(BarcodeComponent barcodeComponent) {
        this.message = JRStringUtil.getString(this.evaluateExpression(barcodeComponent.getCodeExpression()));
        String pattern = JRStringUtil.getString(this.evaluateExpression(barcodeComponent.getPatternExpression()));
        if (pattern != null) {
            this.barcode.setPattern(pattern);
        }
    }

    protected Object evaluateExpression(JRExpression expression) {
        try {
            return this.fillContext.evaluate(expression, this.evaluationType);
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
    }

    @Override
    protected void evaluateCodabar(CodabarComponent codabar) {
        this.evaluateBaseBarcode(codabar);
    }

    @Override
    protected void evaluateCode128(Code128Component code128) {
        this.evaluateBaseBarcode(code128);
    }

    @Override
    protected void evaluateDataMatrix(DataMatrixComponent dataMatrix) {
        this.evaluateBaseBarcode(dataMatrix);
    }

    @Override
    protected void evaluateEANCode128(EAN128Component ean128) {
        this.evaluateBaseBarcode(ean128);
    }

    @Override
    protected void evaluateCode39(Code39Component code39) {
        this.evaluateBaseBarcode(code39);
    }

    @Override
    protected void evaluateUPCA(UPCAComponent upcA) {
        this.evaluateBaseBarcode(upcA);
    }

    @Override
    protected void evaluateUPCE(UPCEComponent upcE) {
        this.evaluateBaseBarcode(upcE);
    }

    @Override
    protected void evaluateEAN13(EAN13Component ean13) {
        this.evaluateBaseBarcode(ean13);
    }

    @Override
    protected void evaluateEAN8(EAN8Component ean8) {
        this.evaluateBaseBarcode(ean8);
    }

    @Override
    protected void evaluateInterleaved2Of5(Interleaved2Of5Component interleaved2Of5) {
        this.evaluateBaseBarcode(interleaved2Of5);
    }

    @Override
    protected void evaluateRoyalMailCustomer(RoyalMailCustomerComponent royalMailCustomer) {
        this.evaluateBaseBarcode(royalMailCustomer);
    }

    @Override
    protected void evaluateUSPSIntelligentMail(USPSIntelligentMailComponent intelligentMail) {
        this.evaluateBaseBarcode(intelligentMail);
    }

    @Override
    protected void evaluatePOSTNET(POSTNETComponent intelligentMail) {
        this.evaluateBaseBarcode(intelligentMail);
    }

    @Override
    protected void evaluatePDF417(PDF417Component pdf417) {
        this.evaluateBaseBarcode(pdf417);
    }
}

