/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.PBKDF2.PRF;
import net.lingala.zip4j.util.Raw;

public class PBKDF2Engine {
    protected PBKDF2Parameters parameters;
    protected PRF prf;

    public PBKDF2Engine() {
        this.parameters = null;
        this.prf = null;
    }

    public PBKDF2Engine(PBKDF2Parameters parameters) {
        this.parameters = parameters;
        this.prf = null;
    }

    public PBKDF2Engine(PBKDF2Parameters parameters, PRF prf) {
        this.parameters = parameters;
        this.prf = prf;
    }

    public byte[] deriveKey(char[] inputPassword) {
        return this.deriveKey(inputPassword, 0);
    }

    public byte[] deriveKey(char[] inputPassword, int dkLen) {
        byte[] r2 = null;
        byte[] P = null;
        if (inputPassword == null) {
            throw new NullPointerException();
        }
        P = Raw.convertCharArrayToByteArray(inputPassword);
        this.assertPRF(P);
        if (dkLen == 0) {
            dkLen = this.prf.getHLen();
        }
        r2 = this.PBKDF2(this.prf, this.parameters.getSalt(), this.parameters.getIterationCount(), dkLen);
        return r2;
    }

    public boolean verifyKey(char[] inputPassword) {
        byte[] referenceKey = this.getParameters().getDerivedKey();
        if (referenceKey == null || referenceKey.length == 0) {
            return false;
        }
        byte[] inputKey = this.deriveKey(inputPassword, referenceKey.length);
        if (inputKey == null || inputKey.length != referenceKey.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < inputKey.length) {
            if (inputKey[i2] != referenceKey[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected void assertPRF(byte[] P) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(P);
    }

    public PRF getPseudoRandomFunction() {
        return this.prf;
    }

    protected byte[] PBKDF2(PRF prf, byte[] S, int c2, int dkLen) {
        if (S == null) {
            S = new byte[]{};
        }
        int hLen = prf.getHLen();
        int l2 = this.ceil(dkLen, hLen);
        int r2 = dkLen - (l2 - 1) * hLen;
        byte[] T = new byte[l2 * hLen];
        int ti_offset = 0;
        int i2 = 1;
        while (i2 <= l2) {
            this._F(T, ti_offset, prf, S, c2, i2);
            ti_offset += hLen;
            ++i2;
        }
        if (r2 < hLen) {
            byte[] DK = new byte[dkLen];
            System.arraycopy(T, 0, DK, 0, dkLen);
            return DK;
        }
        return T;
    }

    protected int ceil(int a2, int b2) {
        int m2 = 0;
        if (a2 % b2 > 0) {
            m2 = 1;
        }
        return a2 / b2 + m2;
    }

    protected void _F(byte[] dest, int offset, PRF prf, byte[] S, int c2, int blockIndex) {
        int hLen = prf.getHLen();
        byte[] U_r = new byte[hLen];
        byte[] U_i = new byte[S.length + 4];
        System.arraycopy(S, 0, U_i, 0, S.length);
        this.INT(U_i, S.length, blockIndex);
        int i2 = 0;
        while (i2 < c2) {
            U_i = prf.doFinal(U_i);
            this.xor(U_r, U_i);
            ++i2;
        }
        System.arraycopy(U_r, 0, dest, offset, hLen);
    }

    protected void xor(byte[] dest, byte[] src) {
        int i2 = 0;
        while (i2 < dest.length) {
            int n2 = i2;
            dest[n2] = (byte)(dest[n2] ^ src[i2]);
            ++i2;
        }
    }

    protected void INT(byte[] dest, int offset, int i2) {
        dest[offset + 0] = (byte)(i2 / 0x1000000);
        dest[offset + 1] = (byte)(i2 / 65536);
        dest[offset + 2] = (byte)(i2 / 256);
        dest[offset + 3] = (byte)i2;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PBKDF2Parameters parameters) {
        this.parameters = parameters;
    }

    public void setPseudoRandomFunction(PRF prf) {
        this.prf = prf;
    }
}

