/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.crypto.AESCipher;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;

public class StandardDecryption {
    protected ARCFOUREncryption arcfour;
    protected AESCipher cipher;
    private byte[] key;
    private static final int AES_128 = 4;
    private boolean aes;
    private boolean initiated;
    private byte[] iv = new byte[16];
    private int ivptr;

    public StandardDecryption(byte[] byArray, int n2, int n3, int n4) {
        boolean bl = this.aes = n4 == 4;
        if (this.aes) {
            this.key = new byte[n3];
            System.arraycopy(byArray, n2, this.key, 0, n3);
        } else {
            this.arcfour = new ARCFOUREncryption();
            this.arcfour.prepareARCFOURKey(byArray, n2, n3);
        }
    }

    public byte[] update(byte[] byArray, int n2, int n3) {
        if (this.aes) {
            if (this.initiated) {
                return this.cipher.update(byArray, n2, n3);
            }
            int n4 = Math.min(this.iv.length - this.ivptr, n3);
            System.arraycopy(byArray, n2, this.iv, this.ivptr, n4);
            n2 += n4;
            n3 -= n4;
            this.ivptr += n4;
            if (this.ivptr == this.iv.length) {
                this.cipher = new AESCipher(false, this.key, this.iv);
                this.initiated = true;
                if (n3 > 0) {
                    return this.cipher.update(byArray, n2, n3);
                }
            }
            return null;
        }
        byte[] byArray2 = new byte[n3];
        this.arcfour.encryptARCFOUR(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    public byte[] finish() {
        if (this.aes) {
            return this.cipher.doFinal();
        }
        return null;
    }
}

