/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.xml.xmp;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmpReader {
    private Document domDocument;

    public XmpReader(byte[] bytes) throws SAXException, IOException {
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            DocumentBuilder db = fact.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            this.domDocument = db.parse(bais);
        }
        catch (ParserConfigurationException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public boolean replaceNode(String namespaceURI, String localName, String value) {
        NodeList nodes = this.domDocument.getElementsByTagNameNS(namespaceURI, localName);
        if (nodes.getLength() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Node node = nodes.item(i2);
            this.setNodeText(this.domDocument, node, value);
            ++i2;
        }
        return true;
    }

    public boolean replaceDescriptionAttribute(String namespaceURI, String localName, String value) {
        NodeList descNodes = this.domDocument.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        if (descNodes.getLength() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < descNodes.getLength()) {
            Node node = descNodes.item(i2);
            Node attr = node.getAttributes().getNamedItemNS(namespaceURI, localName);
            if (attr != null) {
                attr.setNodeValue(value);
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean add(String parent, String namespaceURI, String localName, String value) {
        NodeList nodes = this.domDocument.getElementsByTagName(parent);
        if (nodes.getLength() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Node pNode = nodes.item(i2);
            NamedNodeMap attrs = pNode.getAttributes();
            int j2 = 0;
            while (j2 < attrs.getLength()) {
                Node node = attrs.item(j2);
                if (namespaceURI.equals(node.getNodeValue())) {
                    node = this.domDocument.createElement(localName);
                    node.appendChild(this.domDocument.createTextNode(value));
                    pNode.appendChild(node);
                    return true;
                }
                ++j2;
            }
            ++i2;
        }
        return false;
    }

    public boolean setNodeText(Document domDocument, Node n2, String value) {
        if (n2 == null) {
            return false;
        }
        Node nc = null;
        while ((nc = n2.getFirstChild()) != null) {
            n2.removeChild(nc);
        }
        n2.appendChild(domDocument.createTextNode(value));
        return true;
    }

    public byte[] serializeDoc() throws IOException {
        XmlDomWriter xw = new XmlDomWriter();
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        xw.setOutput(fout, null);
        fout.write("<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n".getBytes("UTF-8"));
        fout.flush();
        NodeList xmpmeta = this.domDocument.getElementsByTagName("x:xmpmeta");
        xw.write(xmpmeta.item(0));
        fout.flush();
        int i2 = 0;
        while (i2 < 20) {
            fout.write("                                                                                                   \n".getBytes());
            ++i2;
        }
        fout.write("<?xpacket end=\"w\"?>".getBytes());
        fout.close();
        return fout.toByteArray();
    }
}

