/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumberTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStructureElement;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PdfStructureTreeRoot
extends PdfDictionary {
    private HashMap<Integer, PdfObject> parentTree = new HashMap();
    private PdfIndirectReference reference;
    private PdfWriter writer;

    PdfStructureTreeRoot(PdfWriter writer) {
        super(PdfName.STRUCTTREEROOT);
        this.writer = writer;
        this.reference = writer.getPdfIndirectReference();
    }

    public void mapRole(PdfName used, PdfName standard) {
        PdfDictionary rm = (PdfDictionary)this.get(PdfName.ROLEMAP);
        if (rm == null) {
            rm = new PdfDictionary();
            this.put(PdfName.ROLEMAP, rm);
        }
        rm.put(used, standard);
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    void setPageMark(int page, PdfIndirectReference struc) {
        Integer i2 = new Integer(page);
        PdfArray ar = (PdfArray)this.parentTree.get(i2);
        if (ar == null) {
            ar = new PdfArray();
            this.parentTree.put(i2, ar);
        }
        ar.add(struc);
    }

    private void nodeProcess(PdfDictionary struc, PdfIndirectReference reference) throws IOException {
        PdfObject obj = struc.get(PdfName.K);
        if (obj != null && obj.isArray() && !((PdfArray)obj).getArrayList().get(0).isNumber()) {
            PdfArray ar = (PdfArray)obj;
            ArrayList<PdfObject> a2 = ar.getArrayList();
            int k2 = 0;
            while (k2 < a2.size()) {
                PdfStructureElement e2 = (PdfStructureElement)a2.get(k2);
                a2.set(k2, e2.getReference());
                this.nodeProcess(e2, e2.getReference());
                ++k2;
            }
        }
        if (reference != null) {
            this.writer.addToBody((PdfObject)struc, reference);
        }
    }

    void buildTree() throws IOException {
        HashMap<Integer, PdfIndirectReference> numTree = new HashMap<Integer, PdfIndirectReference>();
        for (Integer i2 : this.parentTree.keySet()) {
            PdfArray ar = (PdfArray)this.parentTree.get(i2);
            numTree.put(i2, this.writer.addToBody(ar).getIndirectReference());
        }
        PdfDictionary dicTree = PdfNumberTree.writeTree(numTree, this.writer);
        if (dicTree != null) {
            this.put(PdfName.PARENTTREE, this.writer.addToBody(dicTree).getIndirectReference());
        }
        this.nodeProcess(this, this.reference);
    }
}

