/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Name;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.UtilEvalError;
import java.lang.reflect.InvocationTargetException;

class BSHMethodInvocation
extends SimpleNode {
    BSHMethodInvocation(int n2) {
        super(n2);
    }

    BSHAmbiguousName getNameNode() {
        return (BSHAmbiguousName)this.jjtGetChild(0);
    }

    BSHArguments getArgsNode() {
        return (BSHArguments)this.jjtGetChild(1);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        NameSpace nameSpace = callStack.top();
        BSHAmbiguousName bSHAmbiguousName = this.getNameNode();
        if (nameSpace.getParent() != null && nameSpace.getParent().isClass && (bSHAmbiguousName.text.equals("super") || bSHAmbiguousName.text.equals("this"))) {
            return Primitive.VOID;
        }
        Name name = bSHAmbiguousName.getName(nameSpace);
        Object[] objectArray = this.getArgsNode().getArguments(callStack, interpreter);
        try {
            return name.invokeMethod(interpreter, objectArray, callStack, this);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Error in method invocation: " + reflectError.getMessage(), this, callStack);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Method Invocation " + name;
            Throwable throwable = invocationTargetException.getTargetException();
            boolean bl = true;
            if (throwable instanceof EvalError) {
                bl = throwable instanceof TargetError ? ((TargetError)throwable).inNativeCode() : false;
            }
            throw new TargetError(string, throwable, this, callStack, bl);
        }
        catch (UtilEvalError utilEvalError) {
            throw utilEvalError.toEvalError(this, callStack);
        }
    }
}

