/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class P11TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private TlsMasterSecretParameterSpec spec;
    private P11Key p11Key;
    int version;

    P11TlsMasterSecretGenerator(Token token, String string, long l2) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l2;
    }

    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
        SecretKey secretKey = this.spec.getPremasterSecret();
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, secretKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
        this.version = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.version < 768 || this.version > 770) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, and TLS 1.1 supported");
        }
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        CK_VERSION cK_VERSION;
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        if (this.p11Key.getAlgorithm().equals("TlsRsaPremasterSecret")) {
            this.mechanism = this.version == 768 ? 881L : 885L;
            cK_VERSION = new CK_VERSION(0, 0);
        } else {
            this.mechanism = this.version == 768 ? 883L : 887L;
            cK_VERSION = null;
        }
        byte[] byArray = this.spec.getClientRandom();
        byte[] byArray2 = this.spec.getServerRandom();
        CK_SSL3_RANDOM_DATA cK_SSL3_RANDOM_DATA = new CK_SSL3_RANDOM_DATA(byArray, byArray2);
        CK_SSL3_MASTER_KEY_DERIVE_PARAMS cK_SSL3_MASTER_KEY_DERIVE_PARAMS = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS(cK_SSL3_RANDOM_DATA, cK_VERSION);
        Session session = null;
        try {
            SecretKey secretKey;
            int n2;
            int n3;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, 16L, new CK_ATTRIBUTE[0]);
            long l2 = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, cK_SSL3_MASTER_KEY_DERIVE_PARAMS), this.p11Key.keyID, cK_ATTRIBUTEArray);
            cK_VERSION = cK_SSL3_MASTER_KEY_DERIVE_PARAMS.pVersion;
            if (cK_VERSION == null) {
                n3 = -1;
                n2 = -1;
            } else {
                n3 = cK_VERSION.major;
                n2 = cK_VERSION.minor;
            }
            SecretKey secretKey2 = secretKey = P11Key.masterSecretKey(session, l2, "TlsMasterSecret", 384, cK_ATTRIBUTEArray, n3, n2);
            return secretKey2;
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key", exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

