/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = -8939510236124553291L;
    private final Token token;
    private volatile SecureRandom mixRandom;
    private byte[] mixBuffer;
    private int buffered;
    private static final long MAX_IBUFFER_TIME = 100L;
    private static final int IBUFFER_SIZE = 32;
    private transient byte[] iBuffer = new byte[32];
    private transient int ibuffered = 0;
    private transient long lastRead = 0L;

    P11SecureRandom(Token token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void engineSetSeed(byte[] byArray) {
        block9: {
            if (byArray == null) {
                throw new NullPointerException("seed must not be null");
            }
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SeedRandom(session.id(), byArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                SecureRandom secureRandom = this.mixRandom;
                if (secureRandom != null) {
                    secureRandom.setSeed(byArray);
                    break block9;
                }
                try {
                    this.mixBuffer = new byte[20];
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    secureRandom.setSeed(byArray);
                    this.mixRandom = secureRandom;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new ProviderException(noSuchAlgorithmException);
                }
            }
            finally {
                this.token.releaseSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        if (byArray.length <= 32) {
            int n2 = 0;
            byte[] byArray2 = this.iBuffer;
            synchronized (this.iBuffer) {
                while (n2 < byArray.length) {
                    long l2 = System.currentTimeMillis();
                    if (this.ibuffered == 0 || l2 - this.lastRead >= 100L) {
                        this.lastRead = l2;
                        this.implNextBytes(this.iBuffer);
                        this.ibuffered = 32;
                    }
                    while (n2 < byArray.length && this.ibuffered > 0) {
                        byArray[n2++] = this.iBuffer[32 - this.ibuffered--];
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            this.implNextBytes(byArray);
        }
    }

    protected byte[] engineGenerateSeed(int n2) {
        byte[] byArray = new byte[n2];
        this.engineNextBytes(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mix(byte[] byArray) {
        SecureRandom secureRandom = this.mixRandom;
        if (secureRandom == null) {
            return;
        }
        P11SecureRandom p11SecureRandom = this;
        synchronized (p11SecureRandom) {
            int n2 = 0;
            int n3 = byArray.length;
            while (n3-- > 0) {
                if (this.buffered == 0) {
                    secureRandom.nextBytes(this.mixBuffer);
                    this.buffered = this.mixBuffer.length;
                }
                int n4 = n2++;
                byArray[n4] = (byte)(byArray[n4] ^ this.mixBuffer[this.mixBuffer.length - this.buffered]);
                --this.buffered;
            }
        }
    }

    private void implNextBytes(byte[] byArray) {
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_GenerateRandom(session.id(), byArray);
            this.mix(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("nextBytes() failed", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.iBuffer = new byte[32];
        this.ibuffered = 0;
        this.lastRead = 0L;
    }
}

