/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11ECDHKeyAgreement
extends KeyAgreementSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private P11Key privateKey;
    private byte[] publicValue;
    private int secretLen;

    P11ECDHKeyAgreement(Token token, String string, long l2) {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l2;
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = P11KeyFactory.convertKey(this.token, key, "EC");
        this.publicValue = null;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, secureRandom);
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!bl) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        ECPublicKey eCPublicKey = (ECPublicKey)key;
        int n2 = eCPublicKey.getParams().getCurve().getField().getFieldSize();
        this.secretLen = n2 + 7 >> 3;
        this.publicValue = P11ECKeyFactory.getEncodedPublicValue(eCPublicKey);
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, 16L)};
            CK_ECDH1_DERIVE_PARAMS cK_ECDH1_DERIVE_PARAMS = new CK_ECDH1_DERIVE_PARAMS(1L, null, this.publicValue);
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, 16L, cK_ATTRIBUTEArray);
            long l2 = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, cK_ECDH1_DERIVE_PARAMS), this.privateKey.keyID, cK_ATTRIBUTEArray);
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.token.p11.C_GetAttributeValue(session.id(), l2, cK_ATTRIBUTEArray);
            byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
            this.token.p11.C_DestroyObject(session.id(), l2);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not derive key", pKCS11Exception);
        }
        finally {
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (n2 + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n2) + " available");
        }
        byte[] byArray2 = this.engineGenerateSecret();
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!string.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return this.nativeGenerateSecret(string);
    }

    private SecretKey nativeGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        long l2 = 16L;
        Session session = null;
        try {
            SecretKey secretKey;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l2)};
            CK_ECDH1_DERIVE_PARAMS cK_ECDH1_DERIVE_PARAMS = new CK_ECDH1_DERIVE_PARAMS(1L, null, this.publicValue);
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, l2, cK_ATTRIBUTEArray);
            long l3 = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, cK_ECDH1_DERIVE_PARAMS), this.privateKey.keyID, cK_ATTRIBUTEArray);
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(353L)};
            this.token.p11.C_GetAttributeValue(session.id(), l3, cK_ATTRIBUTEArray2);
            int n2 = (int)cK_ATTRIBUTEArray2[0].getLong();
            SecretKey secretKey2 = secretKey = P11Key.secretKey(session, l3, string, n2 << 3, cK_ATTRIBUTEArray);
            return secretKey2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not derive key", pKCS11Exception);
        }
        finally {
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }
}

