/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;
import javax.crypto.SecretKey;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Digest
extends MessageDigestSpi {
    private static final int S_BLANK = 1;
    private static final int S_BUFFERED = 2;
    private static final int S_INIT = 3;
    private static final int BUFFER_SIZE = 96;
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private final int digestLength;
    private Session session;
    private int state;
    private byte[] oneByte;
    private final byte[] buffer;
    private int bufOfs;

    P11Digest(Token token, String string, long l2) {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l2;
        switch ((int)l2) {
            case 512: 
            case 528: {
                this.digestLength = 16;
                break;
            }
            case 544: {
                this.digestLength = 20;
                break;
            }
            case 592: {
                this.digestLength = 32;
                break;
            }
            case 608: {
                this.digestLength = 48;
                break;
            }
            case 624: {
                this.digestLength = 64;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + l2);
            }
        }
        this.buffer = new byte[96];
        this.state = 1;
        this.engineReset();
    }

    protected int engineGetDigestLength() {
        return this.digestLength;
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (this.session == null) {
            return;
        }
        if (this.state != 3 || !this.token.explicitCancel) {
            return;
        }
        try {
            this.token.p11.C_DigestFinal(this.session.id(), this.buffer, 0, this.buffer.length);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("cancel() failed", pKCS11Exception);
        }
        finally {
            this.state = 2;
        }
    }

    private void fetchSession() {
        this.token.ensureValid();
        if (this.state == 1) {
            this.engineReset();
        }
    }

    protected void engineReset() {
        try {
            this.cancelOperation();
            this.bufOfs = 0;
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            this.state = 2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.state = 1;
            throw new ProviderException("reset() failed, ", pKCS11Exception);
        }
    }

    protected byte[] engineDigest() {
        try {
            byte[] byArray = new byte[this.digestLength];
            int n2 = this.engineDigest(byArray, 0, this.digestLength);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException("internal error", digestException);
        }
    }

    protected int engineDigest(byte[] byArray, int n2, int n3) throws DigestException {
        if (n3 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength);
        }
        this.fetchSession();
        try {
            int n4;
            if (this.state == 2) {
                n4 = this.token.p11.C_DigestSingle(this.session.id(), new CK_MECHANISM(this.mechanism), this.buffer, 0, this.bufOfs, byArray, n2, n3);
            } else {
                if (this.bufOfs != 0) {
                    this.doUpdate(this.buffer, 0, this.bufOfs);
                }
                n4 = this.token.p11.C_DigestFinal(this.session.id(), byArray, n2, n3);
            }
            if (n4 != this.digestLength) {
                throw new ProviderException("internal digest length error");
            }
            int n5 = n4;
            return n5;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("digest() failed", pKCS11Exception);
        }
        finally {
            this.state = 1;
            this.bufOfs = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    protected void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.fetchSession();
        if (n3 <= 0) {
            return;
        }
        if (this.bufOfs != 0 && this.bufOfs + n3 > this.buffer.length) {
            this.doUpdate(this.buffer, 0, this.bufOfs);
            this.bufOfs = 0;
        }
        if (this.bufOfs + n3 > this.buffer.length) {
            this.doUpdate(byArray, n2, n3);
        } else {
            System.arraycopy(byArray, n2, this.buffer, this.bufOfs, n3);
            this.bufOfs += n3;
        }
    }

    protected void implUpdate(SecretKey secretKey) throws InvalidKeyException {
        this.fetchSession();
        if (this.bufOfs != 0) {
            this.doUpdate(this.buffer, 0, this.bufOfs);
            this.bufOfs = 0;
        }
        if (!(secretKey instanceof P11Key)) {
            throw new InvalidKeyException("Not a P11Key: " + secretKey);
        }
        P11Key p11Key = (P11Key)((Object)secretKey);
        if (p11Key.token != this.token) {
            throw new InvalidKeyException("Not a P11Key of this provider: " + secretKey);
        }
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), new CK_MECHANISM(this.mechanism));
                this.state = 3;
            }
            this.token.p11.C_DigestKey(this.session.id(), p11Key.keyID);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update(SecretKey) failed", pKCS11Exception);
        }
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.fetchSession();
        int n2 = byteBuffer.remaining();
        if (n2 <= 0) {
            return;
        }
        if (!(byteBuffer instanceof DirectBuffer)) {
            super.engineUpdate(byteBuffer);
            return;
        }
        long l2 = ((DirectBuffer)((Object)byteBuffer)).address();
        int n3 = byteBuffer.position();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), new CK_MECHANISM(this.mechanism));
                this.state = 3;
                if (this.bufOfs != 0) {
                    this.doUpdate(this.buffer, 0, this.bufOfs);
                    this.bufOfs = 0;
                }
            }
            this.token.p11.C_DigestUpdate(this.session.id(), l2 + (long)n3, null, 0, n2);
            byteBuffer.position(n3 + n2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    private void doUpdate(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), new CK_MECHANISM(this.mechanism));
                this.state = 3;
            }
            this.token.p11.C_DigestUpdate(this.session.id(), 0L, byArray, n2, n3);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }
}

