/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class CombinedHash
implements Digest {
    private Digest md5 = new MD5Digest();
    private Digest sha1 = new SHA1Digest();

    public String getAlgorithmName() {
        return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName() + " for TLS 1.0";
    }

    public int getDigestSize() {
        return 36;
    }

    public void update(byte by) {
        this.md5.update(by);
        this.sha1.update(by);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.md5.update(byArray, n2, n3);
        this.sha1.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        int n3 = this.md5.doFinal(byArray, n2);
        int n4 = this.sha1.doFinal(byArray, n2 + 16);
        return n3 + n4;
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

