/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class RecipientInformationStore {
    private Map table = new HashMap();

    public RecipientInformationStore(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
            RecipientId recipientId = recipientInformation.getRID();
            if (this.table.get(recipientId) == null) {
                this.table.put(recipientId, recipientInformation);
                continue;
            }
            Object v2 = this.table.get(recipientId);
            if (v2 instanceof List) {
                ((List)v2).add(recipientInformation);
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v2);
            arrayList.add(recipientInformation);
            this.table.put(recipientId, arrayList);
        }
    }

    public RecipientInformation get(RecipientId recipientId) {
        Object v2 = this.table.get(recipientId);
        if (v2 instanceof List) {
            return (RecipientInformation)((List)v2).get(0);
        }
        return (RecipientInformation)v2;
    }

    public int size() {
        Iterator iterator = this.table.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            if (v2 instanceof List) {
                n2 += ((List)v2).size();
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public Collection getRecipients() {
        ArrayList arrayList = new ArrayList(this.table.size());
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            if (v2 instanceof List) {
                arrayList.addAll((List)v2);
                continue;
            }
            arrayList.add(v2);
        }
        return arrayList;
    }

    public Collection getRecipients(RecipientId recipientId) {
        Object v2 = this.table.get(recipientId);
        if (v2 instanceof List) {
            return new ArrayList((List)v2);
        }
        if (v2 != null) {
            return Collections.singletonList(v2);
        }
        return new ArrayList();
    }
}

