/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509.qualified;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;

public class MonetaryValue
extends ASN1Encodable {
    Iso4217CurrencyCode currency;
    DERInteger amount;
    DERInteger exponent;

    public static MonetaryValue getInstance(Object object) {
        if (object == null || object instanceof MonetaryValue) {
            return (MonetaryValue)object;
        }
        if (object instanceof ASN1Sequence) {
            return new MonetaryValue(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public MonetaryValue(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.currency = Iso4217CurrencyCode.getInstance(enumeration.nextElement());
        this.amount = DERInteger.getInstance(enumeration.nextElement());
        this.exponent = DERInteger.getInstance(enumeration.nextElement());
    }

    public MonetaryValue(Iso4217CurrencyCode iso4217CurrencyCode, int n2, int n3) {
        this.currency = iso4217CurrencyCode;
        this.amount = new DERInteger(n2);
        this.exponent = new DERInteger(n3);
    }

    public Iso4217CurrencyCode getCurrency() {
        return this.currency;
    }

    public BigInteger getAmount() {
        return this.amount.getValue();
    }

    public BigInteger getExponent() {
        return this.exponent.getValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.currency);
        aSN1EncodableVector.add(this.amount);
        aSN1EncodableVector.add(this.exponent);
        return new DERSequence(aSN1EncodableVector);
    }
}

