/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectParser;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    InputStream _in;
    private int _limit;
    private boolean _eofFound;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, Integer.MAX_VALUE);
    }

    public ASN1StreamParser(InputStream inputStream, int n2) {
        this._in = inputStream;
        this._limit = n2;
    }

    public ASN1StreamParser(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    InputStream getParentStream() {
        return this._in;
    }

    private int readLength() throws IOException {
        int n2 = this._in.read();
        if (n2 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n2 == 128) {
            return -1;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n2 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this._in.read();
                if (n4 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n2 = (n2 << 8) + n4;
            }
            if (n2 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n2 >= this._limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n2;
    }

    public DEREncodable readObject() throws IOException {
        int n2;
        int n3;
        int n4 = this._in.read();
        if (n4 == -1) {
            if (this._eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this._eofFound = true;
            return null;
        }
        this.set00Check(false);
        int n5 = n3 = n4 & 0xFFFFFFDF;
        if ((n4 & 0x80) != 0 && (n5 = n4 & 0x1F) == 31) {
            n5 = 0;
            n2 = this._in.read();
            while (n2 >= 0 && (n2 & 0x80) != 0) {
                n5 |= n2 & 0x7F;
                n5 <<= 7;
                n2 = this._in.read();
            }
            if (n2 < 0) {
                this._eofFound = true;
                throw new EOFException("EOF encountered inside tag value.");
            }
            n5 |= n2 & 0x7F;
        }
        if ((n2 = this.readLength()) < 0) {
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in);
            switch (n3) {
                case 5: {
                    while (indefiniteLengthInputStream.read() >= 0) {
                    }
                    return BERNull.INSTANCE;
                }
                case 4: {
                    return new BEROctetStringParser(new ASN1ObjectParser(n4, n5, indefiniteLengthInputStream));
                }
                case 16: {
                    return new BERSequenceParser(new ASN1ObjectParser(n4, n5, indefiniteLengthInputStream));
                }
                case 17: {
                    return new BERSetParser(new ASN1ObjectParser(n4, n5, indefiniteLengthInputStream));
                }
            }
            return new BERTaggedObjectParser(n4, n5, indefiniteLengthInputStream);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n2);
        switch (n3) {
            case 2: {
                return new DERInteger(definiteLengthInputStream.toByteArray());
            }
            case 5: {
                definiteLengthInputStream.toByteArray();
                return DERNull.INSTANCE;
            }
            case 6: {
                return new DERObjectIdentifier(definiteLengthInputStream.toByteArray());
            }
            case 4: {
                return new DEROctetString(definiteLengthInputStream.toByteArray());
            }
            case 16: {
                return new DERSequence(this.loadVector(definiteLengthInputStream, n2)).parser();
            }
            case 17: {
                return new DERSet(this.loadVector(definiteLengthInputStream, n2)).parser();
            }
        }
        return new BERTaggedObjectParser(n4, n5, definiteLengthInputStream);
    }

    private void set00Check(boolean bl) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(bl);
        }
    }

    private ASN1EncodableVector loadVector(InputStream inputStream, int n2) throws IOException {
        DERObject dERObject;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream, n2);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dERObject = aSN1InputStream.readObject()) != null) {
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }
}

