/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.security.internal.nls.Messages;
import org.apache.harmony.security.x501.AttributeTypeAndValue;
import org.apache.harmony.security.x501.AttributeValue;

public class DNParser {
    protected final int length;
    protected int pos;
    protected int beg;
    protected int end;
    protected int cur;
    protected char[] chars;
    protected boolean hasQE;
    protected byte[] encoded;

    public DNParser(String string) throws IOException {
        this.length = string.length();
        this.chars = string.toCharArray();
    }

    protected String nextAT() throws IOException {
        this.hasQE = false;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            throw new IOException(Messages.getString("security.192"));
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.length) {
                throw new IOException(Messages.getString("security.192"));
            }
        }
        ++this.pos;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (!(this.end - this.beg <= 4 || this.chars[this.beg + 3] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[this.beg + 1] != 'I' && this.chars[this.beg + 1] != 'i' || this.chars[this.beg + 2] != 'D' && this.chars[this.beg + 2] != 'd')) {
            this.beg += 4;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    protected String quotedAV() throws IOException {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.length) {
                throw new IOException(Messages.getString("security.192"));
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                break;
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String hexAV() throws IOException {
        if (this.pos + 4 >= this.length) {
            throw new IOException(Messages.getString("security.192"));
        }
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] == ' ') {
                this.end = this.pos++;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n2 = this.pos;
                this.chars[n2] = (char)(this.chars[n2] + 32);
            }
            ++this.pos;
        }
        int n3 = this.end - this.beg;
        if (n3 < 5 || (n3 & 1) == 0) {
            throw new IOException(Messages.getString("security.192"));
        }
        this.encoded = new byte[n3 / 2];
        int n4 = this.beg + 1;
        for (int i2 = 0; i2 < this.encoded.length; ++i2) {
            this.encoded[i2] = (byte)this.getByte(n4);
            n4 += 2;
        }
        return new String(this.chars, this.beg, n3);
    }

    protected String escapedAV() throws IOException {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (this.pos < this.length) {
            switch (this.chars[this.pos]) {
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    this.chars[this.end++] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': {
                    this.cur = this.end;
                    ++this.pos;
                    this.chars[this.end++] = 32;
                    while (this.pos < this.length && this.chars[this.pos] == ' ') {
                        this.chars[this.end++] = 32;
                        ++this.pos;
                    }
                    if (this.pos != this.length && this.chars[this.pos] != ',' && this.chars[this.pos] != '+' && this.chars[this.pos] != ';') continue block5;
                    return new String(this.chars, this.beg, this.cur - this.beg);
                }
            }
            this.chars[this.end++] = this.chars[this.pos];
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private char getEscaped() throws IOException {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IOException(Messages.getString("security.192"));
        }
        switch (this.chars[this.pos]) {
            case '\"': 
            case '\\': {
                this.hasQE = true;
            }
            case ' ': 
            case '#': 
            case '%': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '_': {
                return this.chars[this.pos];
            }
        }
        return this.getUTF8();
    }

    protected char getUTF8() throws IOException {
        int n2 = this.getByte(this.pos);
        ++this.pos;
        if (n2 < 128) {
            return (char)n2;
        }
        if (n2 >= 192 && n2 <= 247) {
            int n3;
            if (n2 <= 223) {
                n3 = 1;
                n2 &= 0x1F;
            } else if (n2 <= 239) {
                n3 = 2;
                n2 &= 0xF;
            } else {
                n3 = 3;
                n2 &= 7;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                ++this.pos;
                if (this.pos == this.length || this.chars[this.pos] != '\\') {
                    return '?';
                }
                ++this.pos;
                int n4 = this.getByte(this.pos);
                ++this.pos;
                if ((n4 & 0xC0) != 128) {
                    return '?';
                }
                n2 = (n2 << 6) + (n4 & 0x3F);
            }
            return (char)n2;
        }
        return '?';
    }

    protected int getByte(int n2) {
        if (n2 + 1 >= this.length) {
            throw new IllegalArgumentException(Messages.getString("security.192"));
        }
        int n3 = this.chars[n2];
        if (n3 >= 48 && n3 <= 57) {
            n3 -= 48;
        } else if (n3 >= 97 && n3 <= 102) {
            n3 -= 87;
        } else if (n3 >= 65 && n3 <= 70) {
            n3 -= 55;
        } else {
            throw new IllegalArgumentException(Messages.getString("security.192"));
        }
        int n4 = this.chars[n2 + 1];
        if (n4 >= 48 && n4 <= 57) {
            n4 -= 48;
        } else if (n4 >= 97 && n4 <= 102) {
            n4 -= 87;
        } else if (n4 >= 65 && n4 <= 70) {
            n4 -= 55;
        } else {
            throw new IllegalArgumentException(Messages.getString("security.192"));
        }
        return (n3 << 4) + n4;
    }

    public List parse() throws IOException {
        ArrayList arrayList = new ArrayList();
        String string = this.nextAT();
        if (string == null) {
            return arrayList;
        }
        ArrayList<AttributeTypeAndValue> arrayList2 = new ArrayList<AttributeTypeAndValue>();
        do {
            if (this.pos == this.length) {
                arrayList2.add(new AttributeTypeAndValue(string, new AttributeValue("", false)));
                arrayList.add(0, arrayList2);
                return arrayList;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    String string2 = this.quotedAV();
                    arrayList2.add(new AttributeTypeAndValue(string, new AttributeValue(string2, this.hasQE)));
                    break;
                }
                case '#': {
                    String string2 = this.hexAV();
                    arrayList2.add(new AttributeTypeAndValue(string, new AttributeValue(string2, this.encoded)));
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    arrayList2.add(new AttributeTypeAndValue(string, new AttributeValue("", false)));
                    break;
                }
                default: {
                    String string2 = this.escapedAV();
                    arrayList2.add(new AttributeTypeAndValue(string, new AttributeValue(string2, this.hasQE)));
                }
            }
            if (this.pos >= this.length) {
                arrayList.add(0, arrayList2);
                return arrayList;
            }
            if (this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                arrayList.add(0, arrayList2);
                arrayList2 = new ArrayList();
            } else if (this.chars[this.pos] != '+') {
                throw new IOException(Messages.getString("security.192"));
            }
            ++this.pos;
        } while ((string = this.nextAT()) != null);
        throw new IOException(Messages.getString("security.192"));
    }
}

