/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.ASN1ValueCollection;
import org.apache.harmony.security.asn1.BerOutputStream;

public final class DerOutputStream
extends BerOutputStream {
    private static final int initSize = 32;
    private int index;
    private int[][] len = new int[32][];
    private Object[][] val = new Object[32][];

    public DerOutputStream(ASN1Type aSN1Type, Object object) {
        this.content = object;
        this.index = -1;
        aSN1Type.setEncodingContent(this);
        this.encoded = new byte[aSN1Type.getEncodedLength(this)];
        this.index = 0;
        aSN1Type.encodeASN(this);
    }

    @Override
    public void encodeChoice(ASN1Choice aSN1Choice) {
        ASN1Type aSN1Type = (ASN1Type)this.val[this.index][0];
        this.content = this.val[this.index][1];
        ++this.index;
        aSN1Type.encodeASN(this);
    }

    @Override
    public void encodeExplicit(ASN1Explicit aSN1Explicit) {
        this.content = this.val[this.index][0];
        this.length = this.len[this.index][0];
        ++this.index;
        aSN1Explicit.type.encodeASN(this);
    }

    @Override
    public void encodeSequence(ASN1Sequence aSN1Sequence) {
        ASN1Type[] aSN1TypeArray = aSN1Sequence.type;
        Object[] objectArray = this.val[this.index];
        int[] nArray = this.len[this.index];
        ++this.index;
        for (int i2 = 0; i2 < aSN1TypeArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            this.content = objectArray[i2];
            this.length = nArray[i2];
            aSN1TypeArray[i2].encodeASN(this);
        }
    }

    @Override
    public void encodeSequenceOf(ASN1SequenceOf aSN1SequenceOf) {
        this.encodeValueCollection(aSN1SequenceOf);
    }

    @Override
    public void encodeSetOf(ASN1SetOf aSN1SetOf) {
        this.encodeValueCollection(aSN1SetOf);
    }

    private final void encodeValueCollection(ASN1ValueCollection aSN1ValueCollection) {
        Object[] objectArray = this.val[this.index];
        int[] nArray = this.len[this.index];
        ++this.index;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.content = objectArray[i2];
            this.length = nArray[i2];
            aSN1ValueCollection.type.encodeASN(this);
        }
    }

    private void push(int[] nArray, Object[] objectArray) {
        ++this.index;
        if (this.index == this.val.length) {
            int[][] nArrayArray = new int[this.val.length * 2][];
            System.arraycopy(this.len, 0, nArrayArray, 0, this.val.length);
            this.len = nArrayArray;
            Object[][] objectArrayArray = new Object[this.val.length * 2][];
            System.arraycopy(this.val, 0, objectArrayArray, 0, this.val.length);
            this.val = objectArrayArray;
        }
        this.len[this.index] = nArray;
        this.val[this.index] = objectArray;
    }

    @Override
    public void getChoiceLength(ASN1Choice aSN1Choice) {
        int n2 = aSN1Choice.getIndex(this.content);
        this.content = aSN1Choice.getObjectToEncode(this.content);
        Object[] objectArray = new Object[]{aSN1Choice.type[n2], this.content};
        this.push(null, objectArray);
        aSN1Choice.type[n2].setEncodingContent(this);
        objectArray[1] = this.content;
    }

    @Override
    public void getExplicitLength(ASN1Explicit aSN1Explicit) {
        Object[] objectArray = new Object[1];
        int[] nArray = new int[1];
        objectArray[0] = this.content;
        this.push(nArray, objectArray);
        aSN1Explicit.type.setEncodingContent(this);
        objectArray[0] = this.content;
        nArray[0] = this.length;
        this.length = aSN1Explicit.type.getEncodedLength(this);
    }

    @Override
    public void getSequenceLength(ASN1Sequence aSN1Sequence) {
        ASN1Type[] aSN1TypeArray = aSN1Sequence.type;
        Object[] objectArray = new Object[aSN1TypeArray.length];
        int[] nArray = new int[aSN1TypeArray.length];
        aSN1Sequence.getValues(this.content, objectArray);
        this.push(nArray, objectArray);
        int n2 = 0;
        for (int i2 = 0; i2 < aSN1TypeArray.length; ++i2) {
            if (objectArray[i2] == null) {
                if (aSN1Sequence.OPTIONAL[i2]) continue;
                throw new RuntimeException();
            }
            if (aSN1Sequence.DEFAULT[i2] != null && aSN1Sequence.DEFAULT[i2].equals(objectArray[i2])) {
                objectArray[i2] = null;
                continue;
            }
            this.content = objectArray[i2];
            aSN1TypeArray[i2].setEncodingContent(this);
            nArray[i2] = this.length;
            objectArray[i2] = this.content;
            n2 += aSN1TypeArray[i2].getEncodedLength(this);
        }
        this.length = n2;
    }

    @Override
    public void getSequenceOfLength(ASN1SequenceOf aSN1SequenceOf) {
        this.getValueOfLength(aSN1SequenceOf);
    }

    @Override
    public void getSetOfLength(ASN1SetOf aSN1SetOf) {
        this.getValueOfLength(aSN1SetOf);
    }

    private void getValueOfLength(ASN1ValueCollection aSN1ValueCollection) {
        Object[] objectArray = aSN1ValueCollection.getValues(this.content).toArray();
        Object[] objectArray2 = new Object[objectArray.length];
        int[] nArray = new int[objectArray2.length];
        this.push(nArray, objectArray2);
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            this.content = objectArray[i2];
            aSN1ValueCollection.type.setEncodingContent(this);
            nArray[i2] = this.length;
            objectArray2[i2] = this.content;
            n2 += aSN1ValueCollection.type.getEncodedLength(this);
        }
        this.length = n2;
    }
}

