/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.internal.nls.Messages;

public final class DerInputStream
extends BerInputStream {
    private static final byte[] UNUSED_BITS_MASK = new byte[]{1, 3, 7, 15, 31, 63, 127};

    public DerInputStream(byte[] byArray) throws IOException {
        super(byArray, 0, byArray.length);
    }

    public DerInputStream(byte[] byArray, int n2, int n3) throws IOException {
        super(byArray, n2, n3);
    }

    public DerInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public final int next() throws IOException {
        int n2 = super.next();
        if (this.length == -1) {
            throw new ASN1Exception(Messages.getString("security.105"));
        }
        return n2;
    }

    @Override
    public void readBitString() throws IOException {
        if (this.tag == 35) {
            throw new ASN1Exception(Messages.getString("security.106", this.tagOffset));
        }
        super.readBitString();
        if (this.length > 1 && this.buffer[this.contentOffset] != 0 && (this.buffer[this.offset - 1] & UNUSED_BITS_MASK[this.buffer[this.contentOffset] - 1]) != 0) {
            throw new ASN1Exception(Messages.getString("security.107", this.contentOffset));
        }
    }

    @Override
    public void readBoolean() throws IOException {
        super.readBoolean();
        if (this.buffer[this.contentOffset] != 0 && this.buffer[this.contentOffset] != -1) {
            throw new ASN1Exception(Messages.getString("security.108", this.contentOffset));
        }
    }

    @Override
    public void readOctetString() throws IOException {
        if (this.tag == 36) {
            throw new ASN1Exception(Messages.getString("security.109", this.tagOffset));
        }
        super.readOctetString();
    }

    @Override
    public void readSequence(ASN1Sequence aSN1Sequence) throws IOException {
        super.readSequence(aSN1Sequence);
    }

    @Override
    public void readSetOf(ASN1SetOf aSN1SetOf) throws IOException {
        super.readSetOf(aSN1SetOf);
    }

    @Override
    public void readString(ASN1StringType aSN1StringType) throws IOException {
        if (this.tag == aSN1StringType.constrId) {
            throw new ASN1Exception(Messages.getString("security.10A", this.tagOffset));
        }
        super.readString(aSN1StringType);
    }

    @Override
    public void readUTCTime() throws IOException {
        if (this.tag == 55) {
            throw new ASN1Exception(Messages.getString("security.10B", this.tagOffset));
        }
        if (this.length != 13) {
            throw new ASN1Exception(Messages.getString("security.10C", this.tagOffset));
        }
        super.readUTCTime();
    }

    @Override
    public void readGeneralizedTime() throws IOException {
        if (this.tag == 56) {
            throw new ASN1Exception(Messages.getString("security.10D", this.tagOffset));
        }
        super.readGeneralizedTime();
    }
}

