/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.harmony.security.asn1.ASN1Time;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public class ASN1UTCTime
extends ASN1Time {
    public static final int UTC_HM = 11;
    public static final int UTC_HMS = 13;
    public static final int UTC_LOCAL_HM = 15;
    public static final int UTC_LOCAL_HMS = 17;
    private static final ASN1UTCTime ASN1 = new ASN1UTCTime();
    private static final String UTC_PATTERN = "yyMMddHHmmss'Z'";

    public ASN1UTCTime() {
        super(23);
    }

    public static ASN1UTCTime getInstance() {
        return ASN1;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readUTCTime();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeUTCTime();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UTC_PATTERN);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        berOutputStream.content = simpleDateFormat.format(berOutputStream.content).getBytes();
        berOutputStream.length = ((byte[])berOutputStream.content).length;
    }
}

