/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.ASN1ValueCollection;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public class ASN1SetOf
extends ASN1ValueCollection {
    public ASN1SetOf(ASN1Type aSN1Type) {
        super(17, aSN1Type);
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readSetOf(this);
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public final void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeSetOf(this);
    }

    @Override
    public final void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.getSetOfLength(this);
    }

    public static ASN1SetOf asArrayOf(ASN1Type aSN1Type) throws IOException {
        return new ASN1SetOf(aSN1Type){

            @Override
            public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
                return ((List)berInputStream.content).toArray();
            }

            @Override
            public Collection getValues(Object object) {
                return Arrays.asList((Object[])object);
            }
        };
    }
}

