/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.harmony.security.asn1.ASN1Primitive;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public class ASN1Integer
extends ASN1Primitive {
    private static final ASN1Integer ASN1 = new ASN1Integer();

    public ASN1Integer() {
        super(2);
    }

    public static ASN1Integer getInstance() {
        return ASN1;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readInteger();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        byte[] byArray = new byte[berInputStream.length];
        System.arraycopy(berInputStream.buffer, berInputStream.contentOffset, byArray, 0, berInputStream.length);
        return byArray;
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeInteger();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.length = ((byte[])berOutputStream.content).length;
    }

    public static int toIntValue(Object object) {
        return new BigInteger((byte[])object).intValue();
    }

    public static Object fromIntValue(int n2) {
        return BigInteger.valueOf(n2).toByteArray();
    }
}

