/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public class ASN1Implicit
extends ASN1Type {
    private static final int TAGGING_PRIMITIVE = 0;
    private static final int TAGGING_CONSTRUCTED = 1;
    private static final int TAGGING_STRING = 2;
    private final ASN1Type type;
    private final int taggingType;

    public ASN1Implicit(int n2, ASN1Type aSN1Type) {
        this(128, n2, aSN1Type);
    }

    public ASN1Implicit(int n2, int n3, ASN1Type aSN1Type) {
        super(n2, n3);
        if (aSN1Type instanceof ASN1Choice || aSN1Type instanceof ASN1Any) {
            throw new IllegalArgumentException(Messages.getString("security.9F"));
        }
        this.type = aSN1Type;
        this.taggingType = aSN1Type.checkTag(aSN1Type.id) ? (aSN1Type.checkTag(aSN1Type.constrId) ? 2 : 0) : 1;
    }

    @Override
    public final boolean checkTag(int n2) {
        switch (this.taggingType) {
            case 0: {
                return this.id == n2;
            }
            case 1: {
                return this.constrId == n2;
            }
        }
        return this.id == n2 || this.constrId == n2;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        if (!this.checkTag(berInputStream.tag)) {
            throw new ASN1Exception(Messages.getString("security.100", new Object[]{berInputStream.tagOffset, Integer.toHexString(this.id), Integer.toHexString(berInputStream.tag)}));
        }
        berInputStream.tag = this.id == berInputStream.tag ? this.type.id : this.type.constrId;
        berInputStream.content = this.type.decode(berInputStream);
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public void encodeASN(BerOutputStream berOutputStream) {
        if (this.taggingType == 1) {
            berOutputStream.encodeTag(this.constrId);
        } else {
            berOutputStream.encodeTag(this.id);
        }
        this.encodeContent(berOutputStream);
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        this.type.encodeContent(berOutputStream);
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        this.type.setEncodingContent(berOutputStream);
    }
}

