/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class ASN1Choice
extends ASN1Type {
    public final ASN1Type[] type;
    private final int[][] identifiers;

    public ASN1Choice(ASN1Type[] aSN1TypeArray) {
        super(0);
        Object object;
        int n2;
        if (aSN1TypeArray.length == 0) {
            throw new IllegalArgumentException(Messages.getString("security.10E", this.getClass().getName()));
        }
        TreeMap treeMap = new TreeMap();
        for (n2 = 0; n2 < aSN1TypeArray.length; ++n2) {
            object = aSN1TypeArray[n2];
            if (object instanceof ASN1Any) {
                throw new IllegalArgumentException(Messages.getString("security.10F", this.getClass().getName()));
            }
            if (object instanceof ASN1Choice) {
                int[][] nArray = ((ASN1Choice)object).identifiers;
                for (int i2 = 0; i2 < nArray[0].length; ++i2) {
                    this.addIdentifier(treeMap, nArray[0][i2], n2);
                }
                continue;
            }
            if (((ASN1Type)object).checkTag(((ASN1Type)object).id)) {
                this.addIdentifier(treeMap, ((ASN1Type)object).id, n2);
            }
            if (!((ASN1Type)object).checkTag(((ASN1Type)object).constrId)) continue;
            this.addIdentifier(treeMap, ((ASN1Type)object).constrId, n2);
        }
        n2 = treeMap.size();
        this.identifiers = new int[2][n2];
        object = treeMap.entrySet().iterator();
        for (int i3 = 0; i3 < n2; ++i3) {
            Map.Entry entry = (Map.Entry)object.next();
            BigInteger bigInteger = (BigInteger)entry.getKey();
            this.identifiers[0][i3] = bigInteger.intValue();
            this.identifiers[1][i3] = ((BigInteger)entry.getValue()).intValue();
        }
        this.type = aSN1TypeArray;
    }

    private void addIdentifier(TreeMap treeMap, int n2, int n3) {
        if (treeMap.put(BigInteger.valueOf(n2), BigInteger.valueOf(n3)) != null) {
            throw new IllegalArgumentException(Messages.getString("security.10F", this.getClass().getName()));
        }
    }

    @Override
    public final boolean checkTag(int n2) {
        return Arrays.binarySearch(this.identifiers[0], n2) >= 0;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        int n2 = Arrays.binarySearch(this.identifiers[0], berInputStream.tag);
        if (n2 < 0) {
            throw new ASN1Exception(Messages.getString("security.110", this.getClass().getName()));
        }
        n2 = this.identifiers[1][n2];
        berInputStream.content = this.type[n2].decode(berInputStream);
        berInputStream.choiceIndex = n2;
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public void encodeASN(BerOutputStream berOutputStream) {
        this.encodeContent(berOutputStream);
    }

    @Override
    public final void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeChoice(this);
    }

    public abstract int getIndex(Object var1);

    public abstract Object getObjectToEncode(Object var1);

    @Override
    public final void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.getChoiceLength(this);
    }
}

