/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryService
implements StreamRepositoryService {
    private ThreadLocal<RepositoryContext> localContext = new ThreadLocal();

    @Override
    public void setContext(RepositoryContext context) {
        this.localContext.set(context);
        ClassLoader classLoader = (ClassLoader)context.getValue("REPORT_CLASS_LOADER");
        URLStreamHandlerFactory urlHandlerFactory = (URLStreamHandlerFactory)context.getValue("REPORT_URL_HANDLER_FACTORY");
        FileResolver fileResolver = (FileResolver)context.getValue("REPORT_FILE_RESOLVER");
        if (classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(classLoader);
        }
        if (urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(urlHandlerFactory);
        }
        if (fileResolver != null) {
            JRResourcesUtil.setThreadFileResolver(fileResolver);
        }
    }

    @Override
    public void revertContext() {
        RepositoryContext context = this.localContext.get();
        ClassLoader classLoader = (ClassLoader)context.getValue("REPORT_CLASS_LOADER");
        URLStreamHandlerFactory urlHandlerFactory = (URLStreamHandlerFactory)context.getValue("REPORT_URL_HANDLER_FACTORY");
        FileResolver fileResolver = (FileResolver)context.getValue("REPORT_FILE_RESOLVER");
        if (classLoader != null) {
            JRResourcesUtil.resetClassLoader();
        }
        if (urlHandlerFactory != null) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
        if (fileResolver != null) {
            JRResourcesUtil.resetThreadFileResolver();
        }
    }

    @Override
    public InputStream getInputStream(String uri) {
        try {
            URL url = JRResourcesUtil.createURL(uri, null);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
            File file = JRResourcesUtil.resolveFile(uri, null);
            if (file != null) {
                return JRLoader.getInputStream(file);
            }
            url = JRResourcesUtil.findClassLoaderResource(uri, null);
            if (url != null) {
                return JRLoader.getInputStream(url);
            }
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource getResource(String uri) {
        throw new JRRuntimeException("Not implemented.");
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        PersistenceService persistenceService = PersistenceUtil.getPersistenceService(DefaultRepositoryService.class, resourceType);
        if (persistenceService != null) {
            return (K)persistenceService.load(uri, this);
        }
        return null;
    }
}

